% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duplicates.R
\name{extract_duplicate_records}
\alias{extract_duplicate_records}
\title{Extract Duplicate Records}
\usage{
extract_duplicate_records(dataset, by_vars)
}
\arguments{
\item{dataset}{A data frame}

\item{by_vars}{A list of variables created using \code{vars()} identifying groups of
records in which to look for duplicates}
}
\value{
A \code{data.frame} of duplicate records within \code{dataset}
}
\description{
Extract Duplicate Records
}
\examples{
data(admiral_adsl)

# Duplicate the first record
adsl <- rbind(admiral_adsl[1L, ], admiral_adsl)

extract_duplicate_records(adsl, vars(USUBJID))
}
\seealso{
Utilities for Dataset Checking: 
\code{\link{get_duplicates_dataset}()},
\code{\link{get_many_to_one_dataset}()},
\code{\link{get_one_to_many_dataset}()}
}
\author{
Thomas Neitmann
}
\concept{utils_ds_chk}
\keyword{utils_ds_chk}
