% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_merged.R
\name{derive_vars_merged_lookup}
\alias{derive_vars_merged_lookup}
\title{Merge Lookup Table with Source Dataset}
\usage{
derive_vars_merged_lookup(
  dataset,
  dataset_add,
  by_vars,
  order = NULL,
  new_vars = NULL,
  mode = NULL,
  filter_add = NULL,
  check_type = "warning",
  duplicate_msg = NULL,
  print_not_mapped = TRUE
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{by_vars} argument are expected.}

\item{dataset_add}{Lookup table

The variables specified by the \code{by_vars} argument are expected.}

\item{by_vars}{Grouping variables

The input dataset and the selected observations from the additional dataset
are merged by the specified by variables. The by variables must be a unique
key of the selected observations.

\emph{Permitted Values}: list of variables created by \code{vars()}}

\item{order}{Sort order

If the argument is set to a non-null value, for each by group the first or
last observation from the additional dataset is selected with respect to the
specified order.

\emph{Default}: \code{NULL}

\emph{Permitted Values}: list of variables or \verb{desc(<variable>)} function calls
created by \code{vars()}, e.g., \code{vars(ADT, desc(AVAL))} or \code{NULL}}

\item{new_vars}{Variables to add

The specified variables from the additional dataset are added to the output
dataset. Variables can be renamed by naming the element, i.e., \verb{new_vars = vars(<new name> = <old name>)}.

For example \code{new_vars = vars(var1, var2)} adds variables \code{var1} and \code{var2}
from \code{dataset_add} to the input dataset.

And \code{new_vars = vars(var1, new_var2 = old_var2)} takes \code{var1} and
\code{old_var2} from \code{dataset_add} and adds them to the input dataset renaming
\code{old_var2} to \code{new_var2}.

If the argument is not specified or set to \code{NULL}, all variables from the
additional dataset (\code{dataset_add}) are added.

\emph{Default}: \code{NULL}

\emph{Permitted Values}: list of variables created by \code{vars()}}

\item{mode}{Selection mode

Determines if the first or last observation is selected. If the \code{order}
argument is specified, \code{mode} must be non-null.

If the \code{order} argument is not specified, the \code{mode} argument is ignored.

\emph{Default}: \code{NULL}

\emph{Permitted Values}: \code{"first"}, \code{"last"}, \code{NULL}}

\item{filter_add}{Filter for additional dataset (\code{dataset_add})

Only observations fulfilling the specified condition are taken into account
for merging. If the argument is not specified, all observations are
considered.

\emph{Default}: \code{NULL}

\emph{Permitted Values}: a condition}

\item{check_type}{Check uniqueness?

If \code{"warning"} or \code{"error"} is specified, the specified message is issued
if the observations of the (restricted) additional dataset are not unique
with respect to the by variables and the order.

\emph{Default}: \code{"warning"}

\emph{Permitted Values}: \code{"none"}, \code{"warning"}, \code{"error"}}

\item{duplicate_msg}{Message of unique check

If the uniqueness check fails, the specified message is displayed.

\emph{Default}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{paste("Dataset `dataset_add` contains duplicate records with respect to",
      enumerate(vars2chr(by_vars)))
}\if{html}{\out{</div>}}}

\item{print_not_mapped}{Print a list of unique \code{by_vars} values that do not
have corresponding records from the lookup table?

\emph{Default}: \code{TRUE}

\emph{Permitted Values}: \code{TRUE}, \code{FALSE}}
}
\value{
The output dataset contains all observations and variables of the
input dataset, and add the variables specified in \code{new_vars} from the lookup
table specified in \code{dataset_add}. Optionally prints a list of unique
\code{by_vars} values that do not have corresponding records
from the lookup table (by specifying \code{print_not_mapped = TRUE}).
}
\description{
Merge user-defined lookup table with the input dataset. Optionally print a
list of records from the input dataset that do not have corresponding
mapping from the lookup table.
}
\examples{
library(admiral.test)
library(tibble)
library(dplyr, warn.conflicts = FALSE)
data("admiral_vs")
param_lookup <- tribble(
  ~VSTESTCD, ~VSTEST, ~PARAMCD, ~PARAM,
  "SYSBP", "Systolic Blood Pressure", "SYSBP", "Systolic Blood Pressure (mmHg)",
  "WEIGHT", "Weight", "WEIGHT", "Weight (kg)",
  "HEIGHT", "Height", "HEIGHT", "Height (cm)",
  "TEMP", "Temperature", "TEMP", "Temperature (C)",
  "MAP", "Mean Arterial Pressure", "MAP", "Mean Arterial Pressure (mmHg)",
  "BMI", "Body Mass Index", "BMI", "Body Mass Index(kg/m^2)",
  "BSA", "Body Surface Area", "BSA", "Body Surface Area(m^2)"
)
derive_vars_merged_lookup(
  dataset = admiral_vs,
  dataset_add = param_lookup,
  by_vars = vars(VSTESTCD),
  new_vars = vars(PARAMCD),
  print_not_mapped = TRUE
)
}
\seealso{
General Derivation Functions for all ADaMs that returns variable appended to dataset:
\code{\link{derive_var_confirmation_flag}()},
\code{\link{derive_var_extreme_flag}()},
\code{\link{derive_var_last_dose_amt}()},
\code{\link{derive_var_last_dose_date}()},
\code{\link{derive_var_last_dose_grp}()},
\code{\link{derive_var_merged_cat}()},
\code{\link{derive_var_merged_character}()},
\code{\link{derive_var_merged_exist_flag}()},
\code{\link{derive_var_merged_summary}()},
\code{\link{derive_var_obs_number}()},
\code{\link{derive_var_relative_flag}()},
\code{\link{derive_var_worst_flag}()},
\code{\link{derive_vars_joined}()},
\code{\link{derive_vars_last_dose}()},
\code{\link{derive_vars_merged}()},
\code{\link{derive_vars_transposed}()},
\code{\link{get_summary_records}()}
}
\author{
Annie Yang
}
\concept{der_gen}
\keyword{der_gen}
