% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_has_variables}
\alias{assert_has_variables}
\title{Does a Dataset Contain All Required Variables?}
\usage{
assert_has_variables(dataset, required_vars)
}
\arguments{
\item{dataset}{A \code{data.frame}}

\item{required_vars}{A \code{character} vector of variable names}
}
\value{
The function throws an error if any of the required variables are
missing in the input dataset. Otherwise, the dataset is returned invisibly.
}
\description{
Checks if a dataset contains all required variables
}
\examples{
library(admiral.test)
data(admiral_dm)

assert_has_variables(admiral_dm, "STUDYID")

try(assert_has_variables(admiral_dm, "AVAL"))
}
\seealso{
Checks for valid input and returns warning or errors messages: 
\code{\link{assert_atomic_vector}()},
\code{\link{assert_character_scalar}()},
\code{\link{assert_character_vector}()},
\code{\link{assert_data_frame}()},
\code{\link{assert_date_vector}()},
\code{\link{assert_expr_list}()},
\code{\link{assert_expr}()},
\code{\link{assert_filter_cond}()},
\code{\link{assert_function_param}()},
\code{\link{assert_function}()},
\code{\link{assert_integer_scalar}()},
\code{\link{assert_list_element}()},
\code{\link{assert_list_of}()},
\code{\link{assert_logical_scalar}()},
\code{\link{assert_named_exprs}()},
\code{\link{assert_named}()},
\code{\link{assert_numeric_vector}()},
\code{\link{assert_one_to_one}()},
\code{\link{assert_param_does_not_exist}()},
\code{\link{assert_s3_class}()},
\code{\link{assert_same_type}()},
\code{\link{assert_symbol}()},
\code{\link{assert_unit}()},
\code{\link{assert_vars}()},
\code{\link{assert_varval_list}()}
}
\concept{assertion}
\keyword{assertion}
