% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_param_response.R
\name{derive_param_response}
\alias{derive_param_response}
\title{Adds a Parameter Indicating If a Subject Had a Response before Progressive
Disease}
\usage{
derive_param_response(
  dataset,
  dataset_adsl,
  filter_source,
  source_pd = NULL,
  source_datasets = NULL,
  set_values_to,
  aval_fun = yn_to_numeric,
  subject_keys = get_admiral_option("subject_keys")
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{subject_keys}and \code{ADT} are expected.

After applying \code{filter_source} and/or \code{source_pd} the variable \code{ADT} and the
variables specified by \code{subject_keys} must be a unique key of the dataset.}

\item{dataset_adsl}{Input dataset
\itemize{
\item The variables specified for \code{subject_keys} are expected.
\item For each observation of the specified dataset a new observation is added
to the input dataset. This is to capture those patients that may never have
had a tumor assessment.
}}

\item{filter_source}{Source filter

All observations in the \code{dataset} data fulfilling the specified condition
are selected.}

\item{source_pd}{Sources and conditions defining the end of the assessment
period for the responses.

An object of type \code{date_source} is expected

All observations in \code{dataset} defining the response data fulfilling the
\code{filter_source} condition are considered as response if they fall before
the end of the assessment period as defined by \code{source_pd}.
\itemize{
\item For subjects with at least one response before the end of the assessment
period, \code{AVALC} is set to \code{"Y"}, \code{AVAL} to \code{1}, and \code{ADT} to the first
date when the response occurred.
\item For all other subjects \code{AVALC} is set to \code{"N"}, \code{AVAL} to \code{0}, and
\code{ADT} to \code{NA}.
}}

\item{source_datasets}{Source dataset

A named list of datasets with one element is expected
(e.g. \code{list(adrs= adrs)}).

The name must match the \code{dataset_name} field of the
\code{admiral::date_source()} object specified for \code{source_pd}.

The variables specified by the \code{subject_keys} argument and the \code{date}
field of the \code{admiral::date_source()} object are expected in the dataset.}

\item{set_values_to}{Variables to set

A named list returned by \code{exprs()} defining the variables to be set for the
new parameter, e.g. \code{exprs(PARAMCD = "RSP", PARAM = "Response by investigator")} is expected.

The values must be symbols, character strings, numeric values or \code{NA}.}

\item{aval_fun}{Function to map character analysis value (\code{AVALC}) to numeric
analysis value (\code{AVAL})

The (first) argument of the function must expect a character vector and the
function must return a numeric vector.}

\item{subject_keys}{Variables to uniquely identify a subject

A list of symbols created using \code{exprs()} is expected.}
}
\value{
The input dataset with a new parameter indicating if and when a
response occurred
}
\description{
Adds a parameter indicating if a response has been observed.
If a response has been observed, \code{AVALC} is set to "Y", \code{AVAL} to 1 and \code{ADT}
is set to the
first date when a response has been observed.
If a response has not been observed, \code{AVALC} is set to "N", \code{AVAL} to 0 and
\code{ADT} is set NA.
}
\details{
\enumerate{
\item The Date of the end of the assessment period (e.g. Progressive disease,
as defined by \code{pd_source}) is added to the response dataset.
\item The response dataset is restricted to observations occurring before
** or on ** the date of progressive disease.
\item For each subject (with respect to the variables specified for the
\code{subject_keys} parameter), the first observation (with respect to
\code{ADT}) where the response condition (\code{filter_source} parameter) is
fulfilled is selected.
\item For each observation in \code{dataset_adsl} a new observation is created.
}
\itemize{
\item For subjects with a response \code{AVALC} is set to \code{"Y"}, \code{AVAL} to \code{1},
and \code{ADT} to  the first date (\code{ADT}) where the response condition is
fulfilled.
\item For all other subjects \code{AVALC} is set to \code{"N"}, \code{AVAL} to \code{0}
and \code{ADT} to \code{NA}.
}
\enumerate{
\item The variables specified by the \code{set_values_to} parameter are added to
the new observations.
\item The new observations are added to input dataset.
}
}
\examples{
library(dplyr)
library(admiral)
library(lubridate)
library(rlang)

adsl <- tibble::tribble(
  ~USUBJID,
  "1",
  "2",
  "3",
  "4"
) \%>\%
  mutate(STUDYID = "XX1234")

adrs <- tibble::tribble(
  ~USUBJID, ~PARAMCD, ~ADTC,         ~AVALC, ~ANL01FL,
  "1",      "OVR",    "2020-01-02",  "PR",   "Y",
  "1",      "OVR",    "2020-02-01",  "CR",   "Y",
  "1",      "OVR",    "2020-03-01",  "CR",   "Y",
  "1",      "OVR",    "2020-04-01",  "SD",   "Y",
  "1",      "PD",     NA_character_, "N",    "Y",
  "2",      "OVR",    "2021-06-15",  "SD",   "Y",
  "2",      "OVR",    "2021-07-16",  "PD",   "Y",
  "2",      "OVR",    "2021-09-14",  "PD",   "Y",
  "2",      "PD",     "2021-09-14",  "Y",    "Y",
  "3",      "OVR",    "2021-09-14",  "SD",   "Y",
  "3",      "OVR",    "2021-10-30",  "PD",   "Y",
  "3",      "OVR",    "2021-12-25",  "CR",   "Y",
  "3",      "PD",     "2021-10-30",  "Y",    "Y"
) \%>\%
  mutate(
    STUDYID = "XX1234",
    ADT = ymd(ADTC),
    ANL01FL = "Y"
  ) \%>\%
  select(-ADTC)

# Define the end of the assessment period for responses:
# all responses before or on the first PD will be used.
pd <- date_source(
  dataset_name = "adrs",
  date = ADT,
  filter = PARAMCD == "PD" & AVALC == "Y"
)
# Derive the response parameter
derive_param_response(
  dataset = adrs,
  dataset_adsl = adsl,
  filter_source = PARAMCD == "OVR" & AVALC \%in\% c("CR", "PR") & ANL01FL == "Y",
  source_pd = pd,
  source_datasets = list(adrs = adrs),
  set_values_to = exprs(
    PARAMCD = "RSP",
    PARAM = "Response by investigator"
  ),
  subject_keys = get_admiral_option("subject_keys")
) \%>\%
  arrange(USUBJID, PARAMCD, ADT)
}
\seealso{
ADRS Functions for adding Parameters: 
\code{\link{derive_param_bor}()},
\code{\link{derive_param_clinbenefit}()},
\code{\link{derive_param_confirmed_bor}()},
\code{\link{derive_param_confirmed_resp}()}
}
\author{
Samia Kabi
}
\concept{der_prm_adrs}
\keyword{der_prm_adrs}
