% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fitting.R
\name{calculate_concentration}
\alias{calculate_concentration}
\title{Building a proxy concentration matrix.}
\usage{
calculate_concentration(data, Z.value)
}
\arguments{
\item{data}{The data containing at least the expected values of \eqn{f} statistics
(column \code{D}) and possibly also products of expected values and \eqn{f}
statistics divided by standard deviations of (the \eqn{Z} scores,
column \code{Z.value}).}

\item{Z.value}{Tells whether the \eqn{Z} scores are available or should we just use the
                identity matrix.}
}
\value{
The Cholesky decomposition of the inverted covariance matrix.
}
\description{
If we don't have the true concentration matrix of the data rows calculated,
but at least have the \eqn{Z} scores of individual rows, (unrealistically) assuming
independence and calculating the concentration matrix from those is still better
than nothing (\emph{i. e.} the identity matrix).
}

