% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signs.R
\name{add_graph_f4_sign}
\alias{add_graph_f4_sign}
\title{Extend a data frame with f_4 statistics predicted by a graph.}
\usage{
add_graph_f4_sign(data, graph)
}
\arguments{
\item{data}{The data frame to get the labels to compute the \eqn{f_4} 
statistics from.}

\item{graph}{The admixture graph.}
}
\value{
A data frame identical to \code{data} except with an additional 
        column, \code{graph_f4_sign}, containing the sign of the \eqn{f_4}
        statistics as determined by the graph.
}
\description{
Extracts the sign for the \eqn{f_4} statistics predicted by the graph for all
rows in a data frame and extends the data frame with the graph \eqn{f_4}.
}
\details{
The data frame, \code{data}, must contain columns \code{W}, \code{X}, 
\code{Y}, and \code{Z}. The function then computes the sign of the 
\eqn{f4(W, X; Y, Z)} statistics for all rows and adds these as a column, 
\code{graph_f4_sign}, to the data frame.
}

