% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting.R
\name{log_likelihood}
\alias{log_likelihood}
\title{Calculate (essentially) the log likelihood of a graph with parameters, given the observation.}
\usage{
log_likelihood(f, concentration, matrix, graph,
  parameters = extract_graph_parameters(graph))
}
\arguments{
\item{f}{The observed \eqn{f} statistics (the column \code{D} from \code{data}).}

\item{concentration}{The Cholesky decomposition of the inverted covariance matrix. So if \eqn{S}
is the covariance matrix, this is \eqn{C = chol(S^{-1})}{C = chol(S^(-1))} satisfying
\eqn{S^{-1} = C^t C}{S^(-1) = C^t*C}.}

\item{matrix}{A column reduced edge optimisation matrix (typically given by the function
\code{\link{build_edge_optimisation_matrix}}).}

\item{graph}{The admixture graph. Here to give default value for:}

\item{parameters}{Just because we need to know variable names.}
}
\value{
The output is a function. Given admixture proportions \code{x} and edge lengths \code{e}, the graph
        topology \eqn{T} implies an estimate \eqn{F} for the statistics \eqn{f}. This output function
        calculates
        \deqn{l = (F-f)^t S^{-1}(F-f)}{l = (F-f)^t*S^(-1)*(F-f)}
        from \code{x} and \code{e}. Up to a constant error and multiplier that is a log likelihood function, as
        \deqn{\det(2 \pi S)^{-1/2} e^{-l/2}}{det(2*\pi*S)^(-1/2)*exp(-l/2)}
        can be seen as a likelihood of a graph with parameters, given the observation, or the other way around
        (possibly up to a normalization constant).
}
\description{
Or the log likelihood of the observation, given graph with parameters, depending how things are modeled.
Basically this is just \code{\link{cost_function}} that doesn't optimize the edge variables
but has them as an argument instead.
}
\seealso{
\code{\link{cost_function}}

\code{\link{edge_optimisation_function}}

\code{\link{calculate_concentration}}
}

