% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TwoStageDesign.R, R/OneStageDesign.R
\docType{methods}
\name{tunable_parameters}
\alias{tunable_parameters}
\alias{tunable_parameters,TwoStageDesign-method}
\alias{update,TwoStageDesign-method}
\alias{update,OneStageDesign-method}
\title{Switch between numeric and S4 class representation of a design}
\usage{
tunable_parameters(object, ...)

\S4method{tunable_parameters}{TwoStageDesign}(object, ...)

\S4method{update}{TwoStageDesign}(object, params, ...)

\S4method{update}{OneStageDesign}(object, params, ...)
}
\arguments{
\item{object}{\code{TwoStageDesign} object to update}

\item{...}{further optional arguments}

\item{params}{vector of design parameters, must be in same order as returned
by \cr
\code{tunable_parameters}}
}
\description{
Get tunable parameters of a design as numeric vector via
\code{tunable_parameters} or \code{update} a design object with a suitable
vector of values for its tunable parameters.
}
\details{
The \code{tunable} slot of a \code{\link{TwoStageDesign}} stores information about
the set of design parameters which are considered fixed (not changed during
optimization) or tunable (changed during optimization).
For details on how to fix certain parameters or how to make them tunable
again, see \code{\link{make_fixed}} and \code{\link{make_tunable}}.
}
\examples{
design  <- TwoStageDesign(25, 0, 2, 25, 2, order = 5)
tunable_parameters(design)
design2 <-update(design, tunable_parameters(design) + 1)
tunable_parameters(design2)

}
\seealso{
\code{\link{TwoStageDesign}}
}
