% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpart-functions.R
\name{avg_characteristics_rpart}
\alias{avg_characteristics_rpart}
\title{Leaves Average Characteristics}
\usage{
avg_characteristics_rpart(tree, X, gates_point = NULL, gates_sd = NULL)
}
\arguments{
\item{tree}{An \code{rpart} object.}

\item{X}{Covariate matrix (no intercept).}

\item{gates_point}{Estimated GATEs, one for each leaf, in increasing order (from most negative to most positive).}

\item{gates_sd}{Standard errors for estimated GATEs, one for each leaf.}
}
\value{
Prints LATEX code in the console.
}
\description{
Compute the average characteristics of units in each leaf of an \code{\link[rpart]{rpart}} object.
}
\details{
\code{avg_characteristics_rpart} regresses each covariate on a set of dummies denoting leaf membership.
This way, we get the average characteristics of units in each leaf, together with a standard error. Leaves are
ordered in increasing order of their predictions (from most negative to most positive). Standard errors are
estimated via the Eicker-Huber-White estimator.\cr

Compilation of the LATEX code requires the following packages: \code{booktabs}, \code{float}, \code{adjustbox},
\code{multirow}.
}
\references{
\itemize{
  \item R Di Francesco (2022). Aggregation Trees. CEIS Research Paper, 546. \doi{10.2139/ssrn.4304256}.
}
}
\seealso{
\code{\link{causal_ols_rpart}}, \code{\link{estimate_rpart}}
}
\author{
Riccardo Di Francesco
}
