% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rel-cyclicity.R
\name{rel_is_cyclic}
\alias{rel_is_cyclic}
\title{Cyclic Binary Relations}
\usage{
rel_is_cyclic(R)
}
\arguments{
\item{R}{an object coercible to a 0-1 (logical) square matrix,
representing a binary relation on a finite set.}
}
\value{
\code{rel_is_cyclic} returns
a single logical value.
}
\description{
A binary relation \eqn{R} is \emph{cyclic}, iff
its transitive closure is not antisymmetric.
Note that \eqn{R} may be reflexive and still acyclic,
i.e., loops in \eqn{R} are not taken into account.
}
\details{
\code{rel_is_cyclic} has \eqn{O(n^3)} time complexity,
where \eqn{n} is the number of rows in \code{R}
(the implemented algorithm currently verifies whether a depth-first search-based
topological sorting is possible).
Missing values in \code{R} always result in \code{NA}.
}
\seealso{
Other binary_relations: \code{\link{check_comonotonicity}},
  \code{\link{pord_nd}}, \code{\link{pord_spread}},
  \code{\link{pord_weakdom}}, \code{\link{rel_graph}},
  \code{\link{rel_is_antisymmetric}},
  \code{\link{rel_is_asymmetric}},
  \code{\link{rel_is_irreflexive}},
  \code{\link{rel_is_reflexive}},
  \code{\link{rel_is_symmetric}},
  \code{\link{rel_is_total}},
  \code{\link{rel_is_transitive}},
  \code{\link{rel_reduction_hasse}}
}
\concept{binary_relations}
