\name{design.mat}
\alias{design.mat}
%- orderPvalue.
\title{ Experimental design matrix }
\description{
  Generate the design matrix from the fieldbook generated by an experimental plan 
  or a dataframe for analysis.
}
\usage{
design.mat(book, locations)
}

\arguments{
  \item{book}{ data frame or matrix, field book }
  \item{locations}{ numeric, column position of the field book }
}
\value{
X is matrix design.
}
\author{ Felipe de Mendiburu }

\seealso{\code{\link{design.ab}}, \code{\link{design.alpha}},\code{\link{design.bib}}, 
\code{\link{design.crd} }, \code{\link{design.cyclic} }, \code{\link{design.split} },
\code{\link{design.graeco}}, \code{\link{design.lattice}}, \code{\link{design.lsd}},
\code{\link{design.rcbd}}, \code{\link{design.strip}}, \code{\link{design.dau}} }

\examples{
# dataframe: data analysis
library(agricolae)
data(sweetpotato)
X<-design.mat(sweetpotato,1)
print(X)
# fieldbook: RCBD design
trt <- LETTERS[1:4]
r<-3
plan<-design.rcbd(trt,r,seed=11)
X<-design.mat(plan$book,2:3)
print(X)
}
\keyword{ manip }% at least one, from doc/KEYWORDS

