% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h2o_predict.R
\name{h2o_predict}
\alias{h2o_predict}
\alias{h2o_predict_classification}
\alias{h2o_predict_regression}
\alias{predict._H2OAutoML}
\title{Prediction wrappers for h2o}
\usage{
h2o_predict(object, new_data, ...)

h2o_predict_classification(object, new_data, type = "class", ...)

h2o_predict_regression(object, new_data, type = "numeric", ...)

\method{predict}{`_H2OAutoML`}(object, new_data, id = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{model_fit}}

\item{new_data}{A rectangular data object, such as a data frame.}

\item{...}{Other options passed to \code{\link[h2o:h2o.predict]{h2o::h2o.predict()}}}

\item{type}{A single character value or \code{NULL}. Possible values
are "numeric", "class", "prob", "conf_int", "pred_int", "quantile", "time",
"hazard", "survival", or "raw". When \code{NULL}, \code{predict()} will choose an
appropriate value based on the model's mode.}

\item{id}{Model id in AutoML results.}
}
\value{
For type != "raw", a prediction data frame with the same number of
rows as \code{new_data}. For type == "raw", return the result of
\code{\link[h2o:h2o.predict]{h2o::h2o.predict()}}.
}
\description{
Prediction wrappers for fitted models with h2o engine that include data conversion,
h2o server cleanup, and so on.
}
\details{
For AutoML, prediction is based on the best performing model.
}
\examples{
\dontshow{if (agua:::should_run_examples()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
if (h2o_running()) {
  spec <-
    rand_forest(mtry = 3, trees = 100) \%>\%
    set_engine("h2o") \%>\%
    set_mode("regression")

  set.seed(1)
  mod <- fit(spec, mpg ~ ., data = mtcars)
  h2o_predict_regression(mod$fit, new_data = head(mtcars), type = "numeric")

  # using parsnip
  predict(mod, new_data = head(mtcars))
}
\dontshow{\}) # examplesIf}
}
