% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ahn_main.R
\name{SimAHNnD}
\alias{SimAHNnD}
\title{SimAHNnD}
\usage{
SimAHNnD(ahn, X)
}
\arguments{
\item{ahn}{an object of class "\code{ahn}" produced from the \link{AHNnD} function.}

\item{X}{data frame with the inputs X to be predicted.}
}
\value{
predicted output values for inputs X.
}
\description{
Function to simulate a trained Artificial Hydrocarbon Network.
}
\examples{
# Create data
x <- 2 * runif(1000) - 1;
x <- sort(x)

y <- (x < 0.1) * (0.05 * runif(100) + atan(pi*x)) +
    (x >= 0.1 & x < 0.6) * (0.05 * runif(1000) + sin(pi*x)) +
    (x >= 0.6) * (0.05 * runif(1000) + cos(pi*x))

# Create Sigma list
Sigma <- list(X = data.frame(x = x), Y = data.frame(y = y))

# Train AHN
ahn <- AHNnD(Sigma, 5, 0.01, 500)

# Test AHN
X <- data.frame(x = x)
ysim <- SimAHNnD(ahn, X)

}
