% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_decision.R
\name{PlotStackedBarDMF}
\alias{PlotStackedBarDMF}
\title{Stacked barplot for the distribution of the decision given DMF recommendation}
\usage{
PlotStackedBarDMF(
  data,
  dmf.label = "dmf",
  dmf.category = NULL,
  d.colors = c("grey60", "grey30", "grey10"),
  d.labels = c("signature bond", "small cash bond", "large cash bond"),
  legend.position = "none"
)
}
\arguments{
\item{data}{A \code{data.frame} of which columns includes a binary treatment (Z; PSA provision), an ordinal decision (D), and DMF recommendation.}

\item{dmf.label}{Column name of DMF recommendation in the data. The default is \code{"dmf"}.}

\item{dmf.category}{The name of each category of DMF recommendation.}

\item{d.colors}{The color of each decision.}

\item{d.labels}{The label of each decision.}

\item{legend.position}{The position of legend. The default is \code{"none"}.}
}
\value{
A list of three ggplots.
}
\description{
See Figure 1 for example.
}
\examples{
data(psa_synth)
PlotStackedBarDMF(psa_synth, dmf.label = "DMF", d.colors = c("grey80", 
                  "grey60", "grey30", "grey10"), d.labels = c("signature",
                  "small","middle","large"))

}
