% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/akclustr.R
\name{akclustr}
\alias{akclustr}
\title{Anchored k-medoids clustering}
\usage{
akclustr(traj, id_field = FALSE, method = "linear",
k = c(3,6), crit="Silhouette", verbose = TRUE, quality_plot=FALSE)
}
\arguments{
\item{traj}{[matrix (numeric)]: longitudinal data. Each row represents
an individual trajectory (of observations). The columns show the
observations at consecutive time steps.}

\item{id_field}{[numeric or character] Whether the first column of the
\code{traj} is a unique (\code{id}) field. Default: \code{FALSE}.
If \code{TRUE} the function recognizes the second column as the first
time points.}

\item{method}{[character] The parametric initialization strategy.
Currently, the only available method is a \code{linear} method, set as
\code{"linear"}. This uses the time-dependent linear regression lines
and the resulting groups are order in the order on increasing slopes.}

\item{k}{[integer or vector (numeric)] either an exact integer number
of clusters, or a vector of length two specifying the minimum and
maximum numbers of clusters to be examined from which the best
solution will be determined. In either case, the minimum number
of clusters is \code{3}. The default is \code{c(3,6)}.}

\item{crit}{[character] a string specifying the type of the criterion
to use for assessing the quality of the cluster solutions, when
\code{k} is a vector of two values (as above). Default:
\code{crit="Silhouette"}, use the average Silhouette width
(\code{Rousseeuw P. J. 1987}). Using the \code{"Silhouette"} criterion,
the optimal value of \code{k} can be determined as the elbow point of
the curve. Other valid criterion is the "Calinski_Harabasz"
(\code{Caliński T. & Harabasz J. 1974}) in which the maximum score
represents the point of optimality. Having determined the optimal
\code{k}, the function can then be re-run, using the exact (optimal)
value of \code{k}.}

\item{verbose}{to suppress output messages (to the console)
during clustering. Default: \code{TRUE}.}

\item{quality_plot}{Whether to show plot of quality criteria across
different values of \code{k}. Default: \code{FALSE}.}
}
\value{
generates an \code{akobject} consisting of the
cluster solutions at the specified values of \code{k}. Also,
the graphical plot of the quality scores of the cluster
solutions.
}
\description{
Given a list of trajectories and a functional method,
this function clusters the trajectories into a \code{k} number of
groups. If a vector of two numbers is given, the function determines
the best solution from those options based on the Caliński-Harabasz
criterion.
}
\details{
This function works by first approximating the trajectories
based on the chosen parametric forms (e.g. linear), and then partitions
the original trajectories based on the form groupings, in similar
fashion to k-means clustering \code{(Genolini et al. 2015)}. The key
distinction of \code{akmedoids} compared with existing longitudinal
approaches is that both the initial starting points as well as the
subsequent cluster centers (as the iteration progresses) are based
the selection of observations (medoids) as oppose to centroids.
}
\examples{

data(traj)

trajectry <- data_imputation(traj, id_field = TRUE, method = 2,
replace_with = 1, fill_zeros = FALSE)

trajectry <- props(trajectry$CompleteData, id_field = TRUE)

print(trajectry)

output <- akclustr(trajectry, id_field = TRUE,
method = "linear", k = c(3,7), crit='Calinski_Harabasz',
verbose = FALSE, quality_plot=FALSE)

print(output)

}
\references{
\code{1}. Genolini, C. et al. (2015) kml and kml3d:
R Packages to Cluster Longitudinal Data. Journal of Statistical
Software, 65(4), 1-34. URL http://www.jstatsoft.org/v65/i04/.

\code{2}. Rousseeuw P. J. (1987) Silhouettes: A graphical aid
to the interpretation and validation of cluster analysis.
J. Comput. Appl. Math 20:53–65.

\code{3}. Caliński T, Harabasz J (1974) A dendrite method for
cluster analysis. Commun. Stat. 3:1-27.
}
