% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_rows_n.R
\name{remove_rows_n}
\alias{remove_rows_n}
\title{Removes rows that contain 'NA' and/or 'Inf' entries}
\usage{
remove_rows_n(traj, id_field=TRUE, remove=1)
}
\arguments{
\item{traj}{[data.frame (numeric)]: longitudinal data.
Each row represents an individual trajectory (of observations).
The columns show the observations at consecutive time points.}

\item{id_field}{[numeric or character] Whether the first column
of the \code{traj} is a unique (\code{id}) field.
Default: \code{FALSE}. If \code{TRUE} the function recognises
the second column as the first time step.}

\item{remove}{[integer] Type of missing entries to remove.
\code{1} for 'NA', \code{2} for 'Inf', and \code{3} for both.
Default:\code{1}.}
}
\value{
A matrix with complete observations
}
\description{
This function removes any rows in which an 'NA'
or an 'Inf' entry is found. The function is also able to
remove records with 'Inf' entries, distinguishing it from
the popular 'na.omit()' function in R.
}
\details{
Given a matrix (or a dataframe) containing an 'NA' or
an 'Inf' entry, the function returns only rows with
complete observations.
}
\examples{

data(traj)

remove_rows_n(traj, id_field=TRUE, remove=3)
}
