% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dkdeGauss}
\alias{dkdeGauss}
\alias{pkdeGauss}
\alias{qkdeGauss}
\title{Gaussian kernel density estimator.}
\usage{
dkdeGauss(x, mu, h)

pkdeGauss(x, mu, h)

qkdeGauss(x, mu, h)
}
\arguments{
\item{x}{A data point, or quantile, at which the kernel density estimator should be evaluated.}

\item{mu}{A vector of data points on which the kernel density estimator is based.}

\item{h}{The kernel density estimator bandwidth.}
}
\value{
dkdeGauss: The estimated value of the density function at the point x.

pkdeGauss: The estimated value of the cumulative distribution function at the point \code{x}.

qkdeGauss: A list with the following components:
\itemize{
\item result: The \code{x}th quantile of the Gaussian kernel density estimator.
\item value: The value of the cumulative distribution function of the Gaussian kernel density estimator at the \code{x}th quantile.
\item obj.fun: The value of the objective function resulting from Brent's method; should be less than 1e-10.
\item iterations: Number of iterations for Brent's method in order to achieve the desired accuracy.
\item steps: Number of range expansions of the search boundaries for Brent's method.
}
}
\description{
Estimate a density function using a kernel density estimator with a Gaussian kernel.
}
\details{
The cumulative distribution function is calculated using the numerical integration C code implimented for R's integrate functions, i.e. using Rdqagi.  For this approximation, subdiv = 100 (100 subdivisions), and eps_abs = eps_rel = 1e-10, i.e. the absolute and relative errors respectively.

The quantiles of the Gaussian kernel density estimator are calculated using Brent's method.  This method requires an interval in which a solution is saught.  The objective funcion for which a zero is saught is \code{\link{dkdeGauss}}-\code{x}, where \code{x} is the quantile saught.  The first interval in which a solution is searched for, corresponds to the range of \code{mu}, and is expanded in multiples thereof in consequtive steps.  The maximum number of iterations is set at 1000, and the accuracy saught between iterations, is set at 1e-10.
}
\examples{
library(alR)
x <- rnorm(100)
h_x <- bw(x, type=1)
dkdeGauss(0, x, h_x)
pkdeGauss(0, x, h_x)
qkdeGauss(0.5, x, h_x)
}
