% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Topology.R
\name{getMRCA}
\alias{getMRCA}
\title{Retrieve the first non-root node of a lineage tree}
\usage{
getMRCA(graph, path = c("distance", "steps"), root = "Germline",
  field = NULL, exclude = NULL)
}
\arguments{
\item{graph}{igraph object containing an annotated lineage tree.}

\item{path}{string defining whether to use unweighted (steps) or weighted (distance) 
measures for determining the founder node set..}

\item{root}{name of the root (germline) node.}

\item{field}{annotation field to use for both unweighted path length exclusion and
consideration as an MRCA node. If \code{NULL} do not exclude any nodes.}

\item{exclude}{vector of annotation values in \code{field} to exclude from the potential 
MRCA set. If \code{NULL} do not exclude any nodes. Has no effect if 
\code{field=NULL}.}
}
\value{
A data.frame of the MRCA node(s) containing the columns:
          \itemize{
            \item  \code{NAME}:      node name
            \item  \code{STEPS}:     path length as the number of nodes traversed
            \item  \code{DISTANCE}:  path length as the sum of edge weights
          }
          Along with additional columns corresponding to the 
          annotations of the input graph.
}
\description{
\code{getMRCA} returns the set of lineage tree nodes with the minimum weighted or 
unweighted path length from the root (germline) of the lineage tree, allowing for 
exclusion of specific groups of nodes.
}
\examples{
# Define example graph
graph <- ExampleTrees[[23]]

# Use unweighted path length and do not exclude any nodes
getMRCA(graph, path="steps", root="Germline")

# Exclude nodes without an isotype annotation and use weighted path length
getMRCA(graph, path="distance", root="Germline", field="ISOTYPE", exclude=NA)

}
\seealso{
Path lengths are determined with \link{getPathLengths}.
}

