% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aldvmm.mm.R
\name{aldvmm.mm}
\alias{aldvmm.mm}
\title{Creating Design Matrices}
\usage{
aldvmm.mm(mf, Formula, ncmp, lcoef)
}
\arguments{
\item{mf}{a data frame created by \ifelse{html}{\code{\link[stats]{model.frame}}}{\code{stats::model.frame}} including the variables used in formula supplied to \ifelse{html}{\code{\link[aldvmm]{aldvmm}}}{\code{aldvmm()}} plus additional attributes, including "terms" for an object of class "terms" derived from formula.}

\item{Formula}{an object of class \code{"Formula"} created by \ifelse{html}{\code{\link[Formula]{Formula}}}{\code{Formula::Formula}} based on the \code{formula} supplied to \ifelse{html}{\code{\link[aldvmm]{aldvmm}}}{
\code{aldvmm()}}.}

\item{ncmp}{a numeric value of the number of components that are mixed. The
default value is 2. A value of 1 represents a tobit model with a gap
between 1 and the maximum value in \code{'psi'}.}

\item{lcoef}{a character vector of length 2 with labels of objects including
regression coefficients of component distributions (default \code{"beta"})
and coefficients of probabilities of component membership (default
\code{"delta"}).}
}
\value{
a named list of numeric matrices. \item{\code{beta}}{a numeric
  design matrix for the model of component distributions.}
  \item{\code{delta}}{a numeric design matrix of the multinomial logit model
  of probabilities of component membership.}
}
\description{
\ifelse{html}{\code{\link[aldvmm]{aldvmm.mm}}}{\code{aldvmm.mm()}} creates
a list of two design matrices, one of the model of component distributions
(\code{"beta"}) and one of the model of probabilities of component
membership (\code{"delta"}).
}
\details{
\ifelse{html}{\code{\link[aldvmm]{aldvmm.mm}}}{\code{aldvmm.mm()}}
  uses
  \ifelse{html}{\code{\link[stats]{model.matrix}}}{\code{stats::model.matrix()}}
   to create design matrices for models of component distributions
  (\code{"beta"}) and probabilities of component membership (\code{"delta"})
  based on a \code{'Formula'} object created by \ifelse{html}{\code{\link[Formula]{Formula}}}{\code{Formula::Formula}} and a model frame created by \ifelse{html}{\code{\link[stats]{model.frame}}}{\code{stats::model.frame}}. The
  design matrix for probabilities of group membership is only created if
  more than one components are specified in \code{'ncmp'}.
}
