% Generated by roxygen2 (4.0.2): do not edit by hand
\name{m2}
\alias{m2}
\title{Evaluate Macaulay2 Code}
\usage{
m2(code, dir = tempdir(), opts = "--script")
}
\arguments{
\item{code}{Macaulay2 code as either a character string or function; see examples}

\item{dir}{directory to place the files in}

\item{opts}{options for m2}
}
\value{
an object of class m2
}
\description{
Write a Macaulay2 file, evaluate it through a back-end connection to Macaulay2, and bring the output back into R.
}
\examples{
\dontrun{

options(digits = 20)
13^20
m2("13^20") # correct answer
m2("toRR(20,(19004963774880800571392-13^20)/13^20)") # relative error
options(digits = 7)

code <- "
1+1
2+3
100!
R = QQ[x,y,z]
(x+y)^10
curve = ideal( x^4-y^5, x^3-y^7 )
gens gb curve
m = matrix {{x^2, x^2-y^2, x*y*z^7 }}
image m
R = QQ[a..d]
I = ideal(a^3-b^2*c, b*c^2-c*d^2, c^3)
G = gens gb I
G
"
m2(code)


code <- "
R = QQ[x,y,z,t]
I = ideal( t^4 - x, t^3 - y, t^2 - z)
gens gb I
"
m2(code)

}
}

