% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ah_division_ids.R
\name{get_ah_division_ids}
\alias{get_ah_division_ids}
\title{Get Allhomes division (suburb) IDs (name, state, postcode, ID).}
\usage{
get_ah_division_ids(x, quiet = FALSE)
}
\arguments{
\item{x}{A \code{character} vector (or scalar) with suburb + state entries
(e.g. "Balmain, NSW")}

\item{quiet}{If \code{TRUE} then messages are suppressed.}
}
\value{
A \code{tibble} with Allhomes data for the division (suburb), state,
postcode, and ID.
}
\description{
Get Allhomes division (suburb) names and IDs for a (vector of) suburb(s).
The input must be a \code{character} vector of suburbs with states (of the form
"Acton, ACT"), and it uses the Allhomes API to query internal Allhomes data
for matching entries. If successful, it will return a \code{tibble} with Allhomes
division names, states, postcodes and IDs. If unsuccessful, it will skip the
entry.
}
\examples{
\donttest{
get_ah_division_ids(c("Acton, ACT", "Balmain, NSW"))
}
}
