% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generics.R, R/FixedEffectsModel.R,
%   R/MixedEffectsModel.R
\name{predict}
\alias{predict}
\alias{predict,FixedEffectsModel-method}
\alias{predict,MixedEffectsModel-method}
\title{Predict with an allometric model}
\usage{
predict(model, ...)

\S4method{predict}{FixedEffectsModel}(model, ..., output_units = NULL)

\S4method{predict}{MixedEffectsModel}(model, ..., newdata = NULL, output_units = NULL)
}
\arguments{
\item{model}{The allometric model used for prediction}

\item{...}{Additional arguments passed to the \code{predict_fn} of the input model}

\item{output_units}{Optionally specify the output units of the model as a
string, e.g., "ft^3". The provided string must be compatible with the
\code{units::set_units()} function.}

\item{newdata}{A dataframe containing columns that match the names of the arguments given
to \code{predict_ranef}. The values of this data represents information from a
new group of observations for which predictions are desired (e.g., a new
stand or plot).}
}
\value{
A vector of allometric model predictions
}
\description{
Predict with an allometric model
}
\examples{
predict(brackett_rubra, 10, 50)
predict(brackett_rubra, 10, 50, output_units = "m^3")
}
