% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{process_modis_sds}
\alias{process_modis_sds}
\title{Process MODIS sub-datasets}
\usage{
process_modis_sds(
  product = c("MOD11A1", "MOD13A2", "MOD09GA", "MCD19A2"),
  custom_sel = NULL,
  ...
)
}
\arguments{
\item{product}{character(1). Product code.}

\item{custom_sel}{character(1). Custom filter.
If this value is not NULL, preset filter is
overridden.}

\item{...}{Placeholders.}
}
\value{
A character object that conforms to the regular
expression. Details of regular expression in R can be found in \link{regexp}.
}
\description{
Selected MODIS sinusoidal grid product subdataset name selector.
Four presets are supported. \code{custom_sel} supersedes
presets of \code{product} values.
}
\note{
Preset product codes and associated variables include
\itemize{
\item "MOD11A1" - Land surface temperature (LST)
\item "MOD13A2" - Normalized Difference Vegetation Index (NDVI)
\item "MOD09GA" - Surface reflectance, and
\item "MCD19A2" - Aerosol optical depth (AOD).
}

For a full list of available
MODIS product codes, see the "Short Name" column at
\href{https://www.earthdata.nasa.gov/centers/lp-daac}{NASA LP DAAC Search Data Catalog}.
When utilizing a product code from this "Short Name" column, \strong{do
not include} the version number following the period. For example, if "Short
Name" = MCD12C1.006, then \code{product = "MCD12C1"}.
}
\examples{
process_modis_sds(product = "MOD09GA")
}
\seealso{
\link{calculate_modis}
}
\author{
Insang Song
}
