% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intFun.R
\name{intFun.min.max.int.mod.ref}
\alias{intFun.min.max.int.mod.ref}
\title{Range and interval for color bar legend for two raster objects}
\usage{
intFun.min.max.int.mod.ref(mod, ref)
}
\arguments{
\item{mod}{An R object}

\item{ref}{An R object}
}
\value{
Minimum, maximum, and interval value for color bar legend
}
\description{
This function returns the minimum, maximum, and interval value
that can be used to define a color bar legend for two raster objects. This is
useful when plotting a variable from different data sets (e.g. model and
observation-based data).
}
\examples{

library(raster)
library(classInt)
# create a raster object
data <- runif(100,-23,864)
data <- matrix(data, ncol=10)
data <- raster::raster(data)
mod <- data
ref <- data+300
# Get min, max, and interval for color bar legend
mmi <- intFun.min.max.int.mod.ref(mod, ref)

}
\keyword{internal}
