% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vertical.R
\name{update_vertically}
\alias{update_vertically}
\title{Update the vertical flux components}
\usage{
update_vertically(h, sy, net.recharge, p.baseflow, hmin.baseflow)
}
\arguments{
\item{h}{Initial head raster}

\item{sy}{Specific yield [0-1].}

\item{net.recharge}{Net recharge (recharge - draft)}

\item{p.baseflow}{parameter for the baseflow [0-1].}

\item{hmin.baseflow}{head corresponding to zero baseflow.}
}
\value{
Returns a list containing the updated head and computed baseflow.
}
\description{
Update the grids with net recharge and discharge, also computes the baseflow
 from each grid.
}
\examples{


# create synthetic head and parameters
h <- 10
sy <- 0.01
net.recharge <- 1
p.baseflow <- 0.7
hmin.baseflow <- 5

# update the head and compute baseflow
out <- update_vertically(h, sy, net.recharge, p.baseflow, hmin.baseflow)
out

}
