% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/websocket.R
\name{Websocket}
\alias{Websocket}
\title{Websocket}
\value{
A Websocket object.
}
\description{
Handle websocket messages.
}
\examples{
# create an Ambiorix app with websocket support:
if (interactive()) {
  library(ambiorix)

  home_get <- function(req, res) {
    res$send("hello, world!")
  }

  greeting_ws_handler <- function(msg, ws) {
    cat("Received message:", "\n")
    print(msg)
    ws$send("greeting", "Hello from the server!")
  }

  app <- Ambiorix$new(port = 8080)
  app$get("/", home_get)
  app$receive("greeting", greeting_ws_handler)
  app$start()
}

# create websocket client from another R session:
if (interactive()) {
  client <- websocket::WebSocket$new("ws://127.0.0.1:8080", autoConnect = FALSE)

  client$onOpen(function(event) {
    cat("Connection opened\n")

    msg <- list(
      isAmbiorix = TRUE, # __MUST__ be set!
      name = "greeting",
      message = "Hello from the client!"
    )

    # serialise:
    msg <- yyjsonr::write_json_str(msg, auto_unbox = TRUE)

    client$send(msg)
  })

  client$onMessage(function(event) {
    cat("Received message from server:", event$data, "\n")
  })

  client$connect()
}

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Websocket-new}{\code{Websocket$new()}}
\item \href{#method-Websocket-send}{\code{Websocket$send()}}
\item \href{#method-Websocket-print}{\code{Websocket$print()}}
\item \href{#method-Websocket-clone}{\code{Websocket$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Websocket-new"></a>}}
\if{latex}{\out{\hypertarget{method-Websocket-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Websocket$new(ws)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws}}{The websocket}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Constructor
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Websocket-send"></a>}}
\if{latex}{\out{\hypertarget{method-Websocket-send}{}}}
\subsection{Method \code{send()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Websocket$send(name, message)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Name, identifier, of the message.}

\item{\code{message}}{Content of the message, anything that can be
serialised to JSON.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Send a message
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Websocket-print"></a>}}
\if{latex}{\out{\hypertarget{method-Websocket-print}{}}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Websocket$print()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Print
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Websocket-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Websocket-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Websocket$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
