\name{plot.epiman}
\alias{plot.epiman}
\alias{plot.MCepi}

\title{ Plotting Epidemic Trajectories and Costs }
\description{
  These functions provide a visualization of the evolution
  of an epidemic, or multiple epidemics obtained via Monte
  Carlo, and the associated costs of the vaccination strategy
  employed
}
\usage{
\method{plot}{epiman}(x, type = c("epi", "costs", "params", "fracs", 
         "stops"), showd = FALSE, showv = FALSE, prior = FALSE,
         main = NULL, ylim = NULL, tp = NULL, ...)
\method{plot}{MCepi}(x, type = c("epi", "costs", "fracs", "stops"), 
          showd = FALSE, showv = FALSE, main = NULL, ylim = NULL, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{ the object to be plotted, either of class
    \code{"MCepi"} or \code{"epiman"}
  }
  \item{type}{ indicates the type of plot to be produced, including
    the epidemic trajectory/ies (\code{"epi"}, the default), cost(s),
    estimated distribution(s) of parameters (\code{"params"}, only
    in the case of \code{"epiman"}-class objects), the fraction
    vaccinated at each time step (\code{"fracs"}), and the
    vaccination (stopping) threshold (\code{"stops"})}
  \item{main}{ optional title argument for the plot.  If not specified,
    then an automatically generated default is used depending on the
    \code{type} of plot specified }
  \item{ylim}{ optional limit for the y axis of the plot, applies only
  to \code{type="cost"}..}
  \item{tp}{ this argument only applies to \code{plot.epiman} with
    \code{type = "params"} where it should be a \code{list} with scalar
    entries \code{$b}, \code{$k}, \code{$nu}, and \code{$mu} indicating
    the true parameter entries for the evolution of the epidemic to be
    added (for comparison) to the posterior density plots }
  \item{showd}{ logical indicating if deaths should be
    shown in the trajectory plots when \code{type = "epi"} }
  \item{showv}{ indicates if
    vaccinations should be shown in the trajectory plot }
  \item{prior}{ indicates whether the prior density should be added
    to the plots when \code{type = "params"}, otherwise ignored}
  \item{\dots}{ additional arguments passed to \code{\link{plot}} } 
}
\details{
  The functions documented here support visualization
  of \code{"MCepi"}-class objects which are generated by the
  \code{\link{MCepi}} and \code{\link{MCmanage}} function,
  and \code{"epiman"}-class objects are
  generated by the \code{\link{manage}} function.  In both cases they
  enable a visualization of the evolution of the resulting epidemic(s)
  and costs associated with deaths, vaccinations, etc.
}
\value{
  The only output of this function is beautiful plots
}
\references{
D. Merl, L.R. Johnson, R.B. Gramacy, and M.S. Mangel (2010).
\dQuote{\pkg{amei}: An \R Package for the Adaptive Management of
Epidemiological Interventions}.  \emph{Journal of Statistical Software}
\bold{36}(6), 1-32. \url{http://www.jstatsoft.org/v36/i06/}
  
D. Merl, L.R. Johnson, R.B. Gramacy, M.S. Mangel (2009). \dQuote{A
Statistical Framework for the Adaptive Management of Epidemiological
Interventions}.  \emph{PLoS ONE}, \bold{4}(6), e5807.
\url{http://www.plosone.org/article/info:doi/10.1371/journal.pone.0005807}
}
\author{
Daniel Merl <dan@stat.duke.edu>\cr
Leah R. Johnson <leah@statslab.cam.ac.uk>\cr
Robert B. Gramacy <bobby@statslab.cam.ac.uk>\cr
and Mark S. Mangel <msmangl@ams.ucsc.edu>
}
%\note{
% Bobby isn't sure why \code{showv} only exists for one of these
% two functions
%}
\seealso{ \code{\link{MCepi}}, \code{\link{manage}},
  \code{\link{MCmanage}} }
\examples{
## for examples of the usage of these functions,
## please see the documentation for the functions
## listed in the See Also section, above
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ hplot }
