% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ad.R
\name{ad}
\alias{ad}
\alias{ad.formula}
\alias{ad.default}
\alias{print.ad}
\title{ad: anomaly detection with normal probability functions.}
\usage{
ad(x, ...)

\method{ad}{formula}(formula, data, na.action = na.omit, ...)

\method{ad}{default}(x, y, na.action = na.omit, ...)

\method{print}{ad}(x, ...)
}
\arguments{
\item{x}{A matrix of numeric features.}

\item{...}{Currently not used.}

\item{formula}{An object of class "formula": a symbolic description of the
model to be fitted.}

\item{data}{A data frame containing the features (predictors) and target.}

\item{na.action}{A function specifying the action to be taken if NAs are
found.}

\item{y}{A vector of numeric target values, either 0 or 1, with 1
assumed to be anomalous.}
}
\value{
An object of class \code{ad}:
  \item{call}{The original call to \code{ad}.}
  \item{epsilon}{The threshold value.}
}
\description{
ad: anomaly detection with normal probability functions.
}
\details{
\code{amelie} implements anomaly detection with normal probability functions
and maximum likelihood estimates.

Features are assumed to be continuous, and the target is assumed to take
on values of 0 (negative case, no anomaly) or 1 (positive case, anomaly).

The threshold \code{epsilon} is optimized using the F1 score.

Algorithm details are described in the Introduction vignette.

The package follows the anomaly detection approach in Andrew Ng's course on
machine learning.
}
\examples{

x1 <- c(1,.2,3,1,1,.7,-2,-1)
x2 <- c(0,.5,0,.4,0,1,-.3,-.1)
x <- do.call(cbind,list(x1,x2))
y <- c(0,0,0,0,0,0,1,1)
dframe <- data.frame(x,y)
df_fit <- ad(y ~ x1 + x2, dframe)
mat_fit <- ad(x = x, y = y)

}
\references{
\url{https://www.coursera.org/learn/machine-learning}
}
