% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_covariates.R
\name{extract_covariates}
\alias{extract_covariates}
\alias{extract_covariates.track_xy}
\alias{extract_covariates.random_points}
\alias{extract_covariates.steps_xy}
\alias{extract_covariates_along}
\alias{extract_covariates_along.steps_xy}
\alias{extract_covariates_var_time}
\alias{extract_covariates_var_time.track_xyt}
\alias{extract_covariates_var_time.steps_xyt}
\title{Extract covariate values}
\usage{
extract_covariates(x, ...)

\method{extract_covariates}{track_xy}(x, covariates, ...)

\method{extract_covariates}{random_points}(x, covariates, ...)

\method{extract_covariates}{steps_xy}(x, covariates, where = "end", ...)

extract_covariates_along(x, ...)

\method{extract_covariates_along}{steps_xy}(x, covariates, ...)

extract_covariates_var_time(x, ...)

\method{extract_covariates_var_time}{track_xyt}(
  x,
  covariates,
  when = "any",
  max_time,
  name_covar = "time_var_covar",
  ...
)

\method{extract_covariates_var_time}{steps_xyt}(
  x,
  covariates,
  when = "any",
  max_time,
  name_covar = "time_var_covar",
  where = "end",
  ...
)
}
\arguments{
\item{x}{\code{[track_xy, track_xyt, steps]} \cr Either a track created with \code{mk_track} or \code{track}, or \code{steps}.}

\item{...}{Additional arguments passed to \code{raster::extract()}.}

\item{covariates}{\verb{[RasterLayer,RasterStack,RasterBrick]} \cr The
(environmental) covariates. For \code{extract_covariates_var_time} the argument
\code{covariates} need to have a \code{z}-column (i.e. the time stamp).}

\item{where}{\verb{[character(1)="end"]\{"start", "end", "both"\}} \cr For \code{steps}
this determines if the covariate values should be extracted at the
beginning or the end of a step. or \code{end}.}

\item{when}{\verb{[character(1)="any"]\{"any", "before", "after"\}} \cr Specifies for
for \code{extract_covariates_var_time} whether to look before, after or in both
direction (\code{any}) for the temporally closest environmental raster.}

\item{max_time}{\verb{[Period(1)]} \cr The maximum time difference between a relocation
and the corresponding raster. If no rasters are within the specified max.
distance \code{NA} is returned.}

\item{name_covar}{\verb{[character(1)="time_var_covar"]} \cr The name of the new column.}
}
\value{
A \code{tibble} with additional columns for covariate values.
}
\description{
Extract the covariate values at relocations, or at the beginning or end of
steps.
}
\details{
\code{extract_covariates_along} extracts the covariates along a straight line between the start and the end point of a (random) step. It returns a list, which in most cases will have to be processed further.
}
\examples{
data(deer)
data(sh_forest)
mini_deer <- deer[1:20, ]
mini_deer \%>\% extract_covariates(sh_forest)
mini_deer \%>\% steps \%>\% extract_covariates(sh_forest)
mini_deer \%>\% steps \%>\% extract_covariates(sh_forest, where = "start")

# Buffer
mini_deer \%>\% extract_covariates(sh_forest) # no buffer
# The command buffer can be used, to buffer each point together with a
# function to summarize the results.
mini_deer \%>\% extract_covariates(sh_forest, buffer = 10, fun = mean)
# This can also be a use-specified function.
mini_deer \%>\% extract_covariates(sh_forest, buffer = 100, fun = function(x) length(x))
\donttest{
# Illustration of extracting covariates along the a step
mini_deer \%>\% steps() \%>\% random_steps() \%>\%
  extract_covariates(sh_forest) \%>\% # extract at the endpoint
  mutate(for_path = extract_covariates_along(., sh_forest))  \%>\%
  # 1 = forest, lets calc the fraction of forest along the path
  mutate(for_per = purrr::map_dbl(for_path, ~ mean(. == 1)))
}
}
