% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hr_kde.R
\name{hr_kde_lscv}
\alias{hr_kde_lscv}
\title{Least square cross validation bandwidth}
\usage{
hr_kde_lscv(
  x,
  range = do.call(seq, as.list(c(hr_kde_ref(x) * c(0.1, 2), length.out = 100))),
  which_min = "global",
  rescale = "none",
  trast = raster(as_sp(x), nrow = 100, ncol = 100)
)
}
\arguments{
\item{x}{\code{[track_xy, track_xyt]} \cr A track created with \code{make_track}.}

\item{range}{numeric vector with different candidate h values.}

\item{which_min}{A character indicating if the \code{global} or \code{local} minimum should be searched for.}

\item{rescale}{\verb{[character(1)]} \cr Rescaling method for reference bandwidth calculation. Must be one of "unitvar", "xvar", or "none".}

\item{trast}{A template raster.}
}
\value{
\code{vector} of length two.
}
\description{
Use least square cross validation (lscv) to estimate bandwidth for kernel home-range estimation.
}
\details{
\code{hr_kde_lscv} calculates least square cross validation bandwidth. This implementation is based on Seaman and Powell (1996).  If \code{whichMin} is \code{"global"} the global minimum is returned, else the local minimum with the largest candidate bandwidth is returned.
}
\references{
Seaman, D. E., & Powell, R. A. (1996). An evaluation of the accuracy of kernel density estimators for home range analysis. \emph{Ecology, 77(7)}, 2075-2085.
}
