% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-functions-meta-pipelines.R
\docType{methods}
\name{getPipelinePrototype}
\alias{getPipelinePrototype}
\alias{getPipelinePrototype,MetaAnalysisPipeline-method}
\title{Obtain the prototype of the functions in the pipeline}
\usage{
getPipelinePrototype(metaPipelineObj)

\S4method{getPipelinePrototype}{MetaAnalysisPipeline}(metaPipelineObj)
}
\arguments{
\item{metaPipelineObj}{A \code{MetaAnalysisPipeline} object}
}
\value{
An object og class \code{proto} from the 'proto' package
}
\description{
Obtain the prototype of the functions in the pipeline
}
\details{
This method returns the prototype of functions in the pipeline and their respective arguments as \code{proto} object.
Functions in the pipeline can be accessed easily by using the '$' operator, and within the functions the arguments can
be accessed the same way. These can be accessed and set to new values. This pipeline prototype can then be passed to the
\code{createPipelineInstance} method which will instantiate an executable pipeline with the inputs set in the prototype
}
\examples{
\dontrun{
pipelineObj <- AnalysisPipeline(input = iris)
pipelineObj \%>>\% univarCatDistPlots(uniCol = "Species") \%>>\%
 exportAsMetaPipeline \%>>\% getPipelinePrototype
}
}
\seealso{
Other Package core functions: \code{\link{BaseAnalysisPipeline-class}},
  \code{\link{MetaAnalysisPipeline-class}},
  \code{\link{assessEngineSetUp}},
  \code{\link{checkSchemaMatch}},
  \code{\link{createPipelineInstance}},
  \code{\link{exportAsMetaPipeline}},
  \code{\link{generateOutput}},
  \code{\link{genericPipelineException}},
  \code{\link{getInput}}, \code{\link{getLoggerDetails}},
  \code{\link{getOutputById}}, \code{\link{getPipeline}},
  \code{\link{getRegistry}},
  \code{\link{initDfBasedOnType}},
  \code{\link{initialize,BaseAnalysisPipeline-method}},
  \code{\link{loadMetaPipeline}},
  \code{\link{loadPipeline}},
  \code{\link{loadPredefinedFunctionRegistry}},
  \code{\link{loadRegistry}}, \code{\link{prepExecution}},
  \code{\link{registerFunction}},
  \code{\link{savePipeline}}, \code{\link{saveRegistry}},
  \code{\link{setInput}}, \code{\link{setLoggerDetails}},
  \code{\link{updateObject}},
  \code{\link{visualizePipeline}}
}
\concept{Package core functions}
