% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcLikelihood.R
\docType{methods}
\name{calcLikelihood}
\alias{calcLikelihood}
\alias{calcLikelihood,MADproject,numeric-method}
\alias{calcLikelihood,MADproject,ANY-method}
\title{Calculate the likelihood for the samples in a MADproject object.}
\usage{
calcLikelihood(proj, dsubset, num_realz = max(proj@realizations$rid),
  samples = 1:proj@numSamples)

\S4method{calcLikelihood}{MADproject,numeric}(proj, dsubset,
  num_realz = max(proj@realizations$rid), samples = 1:proj@numSamples)

\S4method{calcLikelihood}{MADproject,ANY}(proj, num_realz, samples)
}
\arguments{
\item{proj}{The MADproject object with data read from the MAD# databases.}

\item{dsubset}{The subset of inversion data to use for the likelihood
calculations.}

\item{num_realz}{The number of realizations to use in the likelihood
calculation (defaults to all in the \code{realizations} slot)}

\item{samples}{A vector of sample IDs for which to calculate
likelihood values (defaults to all available in the
\code{realizations} slot)}
}
\value{
proj The updated MADproject object with a filled
\code{likelihood} slot.
}
\description{
\code{calcLikelihood} returns an updated MADproject with
the likelihood values based on the
observation and realization data in the MADproject or, optionally,
a subset thereof.
}
\details{
The likelihood calculation utilizes the \pkg{np} package for non-
parametric density estimation with all inversion data as dependent (i.e.
multivariate likelihood distributions are estimated).
}
\section{Methods (by class)}{
\itemize{
\item \code{proj = MADproject,dsubset = numeric}: Calculates the likelihood using a subset \code{dsubset}
of inversion data \code{zid}

\item \code{proj = MADproject,dsubset = ANY}: Calculates the likelihood using all inversion data \code{zid}
}}

\examples{
data(pumping)
pumping <- calcLikelihood(pumping, 100) #Inversion data as time step 100

}
