% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveVideo.R
\name{saveVideo}
\alias{saveVideo}
\title{Convert a sequence of images to a video by FFmpeg}
\usage{
saveVideo(expr, video.name = "animation.mp4", img.name = "Rplot", 
    ffmpeg = ani.options("ffmpeg"), other.opts = if (grepl("[.]mp4$", 
        video.name)) "-pix_fmt yuv420p", ...)
}
\arguments{
\item{expr}{the R code to draw (several) plots}

\item{video.name}{the file name of the output video (e.g.
\file{animation.mp4} or \file{animation.avi})}

\item{img.name}{the file name of the sequence of images to be generated}

\item{ffmpeg}{the command to call FFmpeg (e.g.
\code{'C:/Software/ffmpeg/bin/ffmpeg.exe'} under Windows or 'avconv' on some linux machines); note the full
path of FFmpeg can be pre-specified in \code{\link{ani.options}('ffmpeg')}}

\item{other.opts}{other options to be passed to \code{ffmpeg}, e.g. we can
specify the bitrate as \code{other.opts = '-b 400k'} (The default \code{"-pix_fmt yuv420p"} is a work-around for a bug in some versions of ffmpeg.)}

\item{...}{other arguments to be passed to \code{\link{ani.options}}}
}
\value{
An integer indicating failure (-1) or success (0) of the converting
  (refer to \code{\link{system}}).
}
\description{
This function opens a graphics device to record the images produced in the
code \code{expr}, then uses FFmpeg to convert these images to a video.
}
\details{
This function uses \code{\link{system}} to call FFmpeg to convert the images
to a single video. The command line used in this function is: \command{ffmpeg
-y -r <1/interval> -i <img.name>\%d.<ani.type> other.opts video.name}

where \code{interval} comes from \code{ani.options('interval')}, and
\code{ani.type} is from \code{ani.options('ani.type')}. For more details on
the numerous options of FFmpeg, please see the reference.

Some linux systems may use the alternate software 'avconv' instead of 'ffmpeg'.  The package will attempt to determine which command is present and set \code{\link{ani.options}('ffmpeg')} to an appropriate default value. This can be overridden by passing in the \code{ffmpeg} argument.
}
\note{
There are a lot of possibilities in optimizing the video. My knowledge
  on FFmpeg is very limited, hence the default output by this function could
  be of low quality or too large. The file \file{presets.xml} of WinFF might
  be a good guide: \url{http://code.google.com/p/winff/}.
}
\references{
\url{http://ffmpeg.org/documentation.html}
}
\seealso{
Other utilities: \code{\link{im.convert}},
  \code{\link{saveGIF}}, \code{\link{saveHTML}},
  \code{\link{saveLatex}}, \code{\link{saveSWF}}
}
\author{
Yihui Xie, based on an inital version by Thomas Julou
  \email{thomas.julou@gmail.com}
}
