% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facet-wrap.r
\name{facet_wrap}
\alias{facet_wrap}
\title{Wrap a 1d ribbon of panels into 2d.}
\usage{
facet_wrap(facets, nrow = NULL, ncol = NULL, scales = "fixed",
  shrink = TRUE, labeller = "label_value", as.table = TRUE,
  switch = NULL, drop = TRUE, dir = "h")
}
\arguments{
\item{facets}{Either a formula or character vector. Use either a
one sided formula, \code{~a + b}, or a character vector, \code{c("a", "b")}.}

\item{nrow, ncol}{Number of rows and columns.}

\item{scales}{should Scales be fixed (\code{"fixed"}, the default),
free (\code{"free"}), or free in one dimension (\code{"free_x"},
\code{"free_y"}).}

\item{shrink}{If \code{TRUE}, will shrink scales to fit output of
statistics, not raw data. If \code{FALSE}, will be range of raw data
before statistical summary.}

\item{labeller}{A function that takes one data frame of labels and
returns a list or data frame of character vectors. Each input
column corresponds to one factor. Thus there will be more than
one with formulae of the type \code{~cyl + am}. Each output
column gets displayed as one separate line in the strip
label. This function should inherit from the "labeller" S3 class
for compatibility with \code{\link{labeller}()}. See
\code{\link{label_value}} for more details and pointers to other
options.}

\item{as.table}{If \code{TRUE}, the default, the facets are laid out like
a table with highest values at the bottom-right. If \code{FALSE}, the
facets are laid out like a plot with the highest value at the top-right.}

\item{switch}{By default, the labels are displayed on the top of
the plot. If \code{switch} is \code{"x"}, they will be displayed
to the bottom. If \code{"y"}, they will be displayed to the
left, near the y axis.}

\item{drop}{If \code{TRUE}, the default, all factor levels not used in the
data will automatically be dropped. If \code{FALSE}, all factor levels
will be shown, regardless of whether or not they appear in the data.}

\item{dir}{Direction: either "h" for horizontal, the default, or "v", for
vertical.}
}
\description{
Most displays are roughly rectangular, so if you have a categorical
variable with many levels, it doesn't make sense to try and display them
all in one row (or one column). To solve this dilemma, \code{facet_wrap}
wraps a 1d sequence of panels into 2d, making best use of screen real estate.
}
\examples{
ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  facet_wrap(~class)

# Control the number of rows and columns with nrow and ncol
ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  facet_wrap(~class, nrow = 4)

\donttest{
# You can facet by multiple variables
ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  facet_wrap(~ cyl + drv)
# Or use a character vector:
ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  facet_wrap(c("cyl", "drv"))

# Use the `labeller` option to control how labels are printed:
ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  facet_wrap(c("cyl", "drv"), labeller = "label_both")

# To change the order in which the panels appear, change the levels
# of the underlying factor.
mpg$class2 <- reorder(mpg$class, mpg$displ)
ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  facet_wrap(~class2)

# By default, the same scales are used for all panels. You can allow
# scales to vary across the panels with the `scales` argument.
# Free scales make it easier to see patterns within each panel, but
# harder to compare across panels.
ggplot(mpg, aes(displ, hwy)) +
  geom_point() +
  facet_wrap(~class, scales = "free")

# To repeat the same data in every panel, simply construct a data frame
# that does not contain the facetting variable.
ggplot(mpg, aes(displ, hwy)) +
  geom_point(data = transform(mpg, class = NULL), colour = "grey85") +
  geom_point() +
  facet_wrap(~class)

# Use `switch` to display the facet labels near an axis, acting as
# a subtitle for this axis. This is typically used with free scales
# and a theme without boxes around strip labels.
ggplot(economics_long, aes(date, value)) +
  geom_line() +
  facet_wrap(~variable, scales = "free_y", nrow = 2, switch = "x") +
  theme(strip.background = element_blank())
}
}
