% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facet-labels.r
\name{labeller}
\alias{labeller}
\title{Generic labeller function for facets}
\usage{
labeller(
  ...,
  .rows = NULL,
  .cols = NULL,
  keep.as.numeric = NULL,
  .multi_line = TRUE,
  .default = label_value
)
}
\arguments{
\item{...}{Named arguments of the form \code{variable =
labeller}. Each labeller is passed to \code{\link{as_labeller}()}
and can be a lookup table, a function taking and returning
character vectors, or simply a labeller function.}

\item{.rows, .cols}{Labeller for a whole margin (either the rows or
the columns). It is passed to \code{\link{as_labeller}()}. When a
margin-wide labeller is set, make sure you don't mention in
\code{...} any variable belonging to the margin.}

\item{keep.as.numeric}{Deprecated. All supplied labellers and
on-labeller functions should be able to work with character
labels.}

\item{.multi_line}{Whether to display the labels of multiple
factors on separate lines. This is passed to the labeller
function.}

\item{.default}{Default labeller for variables not specified. Also
used with lookup tables or non-labeller functions.}
}
\value{
A labeller function to supply to \code{\link{facet_grid}}
  for the argument \code{labeller}.
}
\description{
This function makes it easy to assign different labellers to
different factors. The labeller can be a function or it can be a
named character vectors that will serve as a lookup table.
}
\details{
In case of functions, if the labeller has class \code{labeller}, it
is directly applied on the data frame of labels. Otherwise, it is
applied to the columns of the data frame of labels. The data frame
is then processed with the function specified in the
\code{.default} argument. This is intended to be used with
functions taking a character vector such as
\code{\link[Hmisc]{capitalize}}.
}
\examples{
\donttest{
p1 <- ggplot(mtcars, aes(x = mpg, y = wt)) + geom_point()

# You can assign different labellers to variables:
p1 + facet_grid(vs + am ~ gear,
  labeller = labeller(vs = label_both, am = label_value))

# Or whole margins:
p1 + facet_grid(vs + am ~ gear,
  labeller = labeller(.rows = label_both, .cols = label_value))

# You can supply functions operating on strings:
capitalize <- function(string) {
  substr(string, 1, 1) <- toupper(substr(string, 1, 1))
  string
}
p2 <- ggplot(msleep, aes(x = sleep_total, y = awake)) + geom_point()
p2 + facet_grid(vore ~ conservation, labeller = labeller(vore = capitalize))

# Or use character vectors as lookup tables:
conservation_status <- c(
  cd = "Conservation Dependent",
  en = "Endangered",
  lc = "Least concern",
  nt = "Near Threatened",
  vu = "Vulnerable",
  domesticated = "Domesticated"
)
## Source: http://en.wikipedia.org/wiki/Wikipedia:Conservation_status

p2 + facet_grid(vore ~ conservation, labeller = labeller(
  .default = capitalize,
  conservation = conservation_status
))

# In the following example, we rename the levels to the long form,
# then apply a wrap labeller to the columns to prevent cropped text
msleep$conservation2 <- plyr::revalue(msleep$conservation,
  conservation_status)

p2 \%+\% msleep + facet_grid(vore ~ conservation2)
p2 \%+\% msleep +
  facet_grid(vore ~ conservation2,
    labeller = labeller(conservation2 = label_wrap_gen(10))
  )

# labeller() is especially useful to act as a global labeller. You
# can set it up once and use it on a range of different plots with
# different facet specifications.

global_labeller <- labeller(
  vore = capitalize,
  conservation = conservation_status,
  conservation2 = label_wrap_gen(10),
  .default = label_both
)

p2 + facet_grid(vore ~ conservation, labeller = global_labeller)
p2 + facet_wrap(~vore, labeller = global_labeller)
p2 \%+\% msleep + facet_wrap(~conservation2, labeller = global_labeller)
}
}
\seealso{
\code{\link{as_labeller}()}, \link{labellers}
}
\concept{facet labeller}
