% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractBoxes.R
\name{extractAllBoxesFromFlat}
\alias{extractAllBoxesFromFlat}
\title{Extract ,cropped images from a processed dataframe}
\usage{
extractAllBoxesFromFlat(
  images,
  buffer = 0,
  resize = NA,
  quality = 0.8,
  outdir = "",
  save = FALSE,
  overwrite = TRUE,
  parallel = FALSE,
  nproc = parallel::detectCores()
)
}
\arguments{
\item{images}{dataframe containing MD output (assumes single row)}

\item{buffer}{Adds a buffer to the MD bounding box, defaults to 2px}

\item{resize}{Size in pixels to resize cropped images, NA if images are not resized, defaults to NA}

\item{quality}{Compression level of output cropped image, defaults to 0.8}

\item{outdir}{Directory in which output cropped images will be saved}

\item{save}{Toggle to save output cropped, defaults to FALSE}

\item{overwrite}{Toggle to overwrite output cropped images if they already exis, defaults to TRUE}

\item{parallel}{Toggle to enable parallel processing, defaults to FALSE}

\item{nproc}{Number of workers if parallel = TRUE, defaults to output of detectCores()}
}
\value{
A dataframe containing image and crop paths
}
\description{
Extract ,cropped images from a processed dataframe
}
\examples{
\dontrun{
crops <- extractBoxesFromFlat(mdresflat,save=TRUE,out)
}
}
