% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/animate_paths.R
\name{animate_paths}
\alias{animate_paths}
\title{animate paths}
\usage{
animate_paths(
  paths,
  coord = c("x", "y"),
  Time.name = "time",
  background = NULL,
  bg.axes = TRUE,
  bg.misc = NULL,
  bg.opts = NULL,
  blur.size = 8,
  covariate = NULL,
  covariate.colors = c("black", "white"),
  covariate.legend.loc = "bottomright",
  covariate.thresh = NULL,
  crawl.mu.color = "black",
  crawl.plot.type = "point.tail",
  date.col = "black",
  delta.t = NULL,
  dev.opts = list(),
  dimmed = NULL,
  ID.name = NULL,
  interpolation_type = "gam",
  interval = 1/12,
  legend.loc = "topright",
  main = NULL,
  max_refit_attempts = 10,
  method = "html",
  n.frames = NULL,
  network = NULL,
  network.colors = NULL,
  network.thresh = 0.5,
  network.times = NULL,
  network.ring.trans = 1,
  network.ring.wt = 3,
  network.segment.trans = 0.5,
  network.segment.wt = 3,
  override = FALSE,
  par.opts = list(),
  paths.proj = "+proj=longlat",
  paths.tranform.crs = "+proj=aea",
  plot.date = TRUE,
  pt.alpha = 0.4,
  pt.cex = 1,
  pt.colors = NULL,
  pt.wd = 1,
  res = 1.5,
  return.paths = FALSE,
  s_args = NULL,
  simulation = FALSE,
  simulation.iter = 12,
  tail.alpha = 0.6,
  tail.colors = "gray87",
  tail.length = 5,
  tail.wd = 1,
  theme_map = NULL,
  times = NULL,
  uncertainty.level = NA,
  uncertainty.type = 1,
  whole.path = FALSE,
  xlim = NULL,
  ylim = NULL,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{paths}{Either a \code{data.frame} with longitudes/eastings, latitudes/northings, IDs, and times (see \code{coord}, \code{ID.name}, and \code{Time.name}), a \code{SpatialPointsDataFrame} with IDs and times, or a list of data.frames containing the longitudes, latitudes, and times for each individual (with names provided).
If all paths are already synchronous, another option for passing the data is to define \code{paths} as a list of matrices, all with the same number of rows, and to specify the times separately via the next argument. This situation might arise when, for example, locations the user wishes to animated correspond to realizations/sampler from a discrete-time movement model. Covariates may be provided as named columns of the matrices in \code{paths}.}

\item{coord}{A character vector of length 2 giving the names of the longitude/easting and latitude/northing columns in the \code{paths} \code{data.frame} (in that order). This is required if \code{paths} is not a \code{SpatialPointsDataFrame}.}

\item{Time.name}{The name of the columns in \code{paths} gving the observation times. This column must be of class \code{POSIXt}, or numeric.}

\item{background}{Three possibilities: (1) A single background image over which animation will be overlayed, or a SpatRaster objects with one layers corresponding to each frame. (2) A list with values \code{center} (long/lat), \code{zoom}, and \code{maptype} (see \code{ggmap::get_googlemap()}) which will be used to generate a background for the animation based on Google maps tiles. Additional arguments may be added which will be passed to \code{ggmap::get_googlemap()}. (3) A logical value of \code{TRUE}, which will cue the function to get the best Google Map tile combination it can come up with. Note: \code{ggmap} must be installed for (2) and (3). Note: if you are calling \code{animate_paths()} several times in a short period of time you may get an error from Google for trying to pull tiles too often (e.g., \code{Error in download.file(url, destfile = tmp, quiet = !messaging, mode = "wb") : cannot open URL 'http://maps.googleapis...'}). Waiting a minute or so usually solves this.}

\item{bg.axes}{logical: should animation place axis labels when using a background image (default is \code{TRUE}). If \code{RGoogleMaps} is used to produce background, labels will be "northing" and "easting". Otherwise, the strings given to \code{coord} will be used.}

\item{bg.misc}{Character string which will be executed as \code{R} code after generating the background, and before adding trajectories, etc.}

\item{bg.opts}{Options passed to \code{plot()} function call that makes background in each frame. For example, this could be used to specify blue ocean and gray landcover if \code{background} is a \code{MULTIPOLYGON} simple features object and \code{bg.opts = list(bg = "dodgerblue4", col = "gray", border = "gray")}.}

\item{blur.size}{a integer of the size for blur points; default is 8}

\item{covariate}{The name of the column in \code{paths} that identifies the covariate to be mapped to a ring of color around each point.}

\item{covariate.colors}{vector of colors which will be used in their given order to make a color ramp (see \code{colorRamp()})}

\item{covariate.legend.loc}{either the location of the covariate legend, or \code{NA} if no legend is desired}

\item{covariate.thresh}{if changed from its default value of \code{NULL}, the interpolated value of the covariate will be binarized based on this numeric value.}

\item{crawl.mu.color}{color for the main predictions for crawl interpolation; default is black}

\item{crawl.plot.type}{a character string of what type of the plot you wish to generate when \code{interpolation_type = "crawl"}. Default is "point.tail" for points with tails; input "point" for point plot and input "blur" for blur point plot; ; input "blur.point" for blur point with tails.}

\item{date.col}{default is \code{"black"}}

\item{delta.t}{The gap in time between each frame in the animation. Specify one of \code{delta.t} or \code{n.frames}. If both are specified, \code{delta.t} is used.}

\item{dev.opts}{Options passed to \code{png()} before creating each frame.}

\item{dimmed}{Numeric vector of individuals to "dim" in the animation. Order corresponds to the order of the ID.name variable, or order of paths list.}

\item{ID.name}{The name of the column in \code{paths} that identifies each individual. If left as \code{NULL} (default), a single individual is assumed.}

\item{interpolation_type}{a character string of the type of interpolation. Default is "gam" for a generalized addictive model. Use "crawl" to interpolate using \code{crawl} package. Note: due to the ongoing shift in PROJ4/6 standards, warning about CRS comments may appear.}

\item{interval}{Seconds per frame in animation. Default is 1/12 (or 12 frames per second).}

\item{legend.loc}{passed to first argument of \code{legend()} function. Default is \code{"topright"}. \code{NA} removes legend.}

\item{main}{Title for each frame.}

\item{max_refit_attempts}{an integer of number of resampling when the fit for crawl failed to run; default is 10}

\item{method}{either \code{"html"} (default) or \code{"mp4"}. The latter requires the user has installed \code{ffmpeg} (see \code{?animation::saveVideo()}).}

\item{n.frames}{The number of frames used to animate the complete time domain of the data.}

\item{network}{Array of dimensions (# individuals, # individuals, \code{n.frames}) that gives a dyanmic network structure among the individuals.}

\item{network.colors}{A symmetric matrix of dimension \code{length(paths)} \eqn{\times} \code{length(paths)} giving the colors associated with each pairwise relationship.}

\item{network.thresh}{Network structure is summarized in the animation in a binary way, regardless of whether or not the \code{network} is continuously weighted or not. The value of \code{network.thresh} determines the level below which no connection is shown, and above which an active connection is shown via colored rings and connecting segments.}

\item{network.times}{Numeric vector. If network time grid doesn't match \code{n.frames}, supply the times at which the network has been evaluated so it can be interpolated using smoothing splines.}

\item{network.ring.trans}{transparency of network segments (default is 1)}

\item{network.ring.wt}{thickness of network rings (default is 3)}

\item{network.segment.trans}{transparency of network segments (default is 0.5)}

\item{network.segment.wt}{thickness of network segments (default is 3)}

\item{override}{Logical variable toggling where or not to override warnings about how long the animation procedure will take.}

\item{par.opts}{Options passed to \code{par()} before creating each frame.}

\item{paths.proj}{PROJ.4 string corresponding to the projection of the data. Default is "+proj=longlat".}

\item{paths.tranform.crs}{a PROJ.4 string of coordinate projection transformation based on the animals' location; default is "+proj=aea +lat_1=30 +lat_2=70".}

\item{plot.date}{Logical variable toggling date text at the time center of the animation.}

\item{pt.alpha}{alpha value for the points}

\item{pt.cex}{A numeric value giving the character expansion (size) of the points for each individual. Default is 1.}

\item{pt.colors}{A vector of colors to be used for each individual in the animation. Default values come from Color Brewer palettes. When a network is provided, this is ignored and individuals are all colored black. If \code{NA}, no plot colors are chosen to distinguish individuals. This can be useful when making animations involving a covariate. Consider also setting \code{legend.loc} to \code{NA} in this case.}

\item{pt.wd}{size of the points; default is 1}

\item{res}{Resolution of images in animation. Increase this for higher quality (and larger) images.}

\item{return.paths}{logical. Default is \code{FALSE}, but if \code{TRUE} then the interpolated paths are returned and no animation is produced.}

\item{s_args}{Default is \code{NULL}, in which case \code{anipaths} attempts to select a reasonable number of knots for the GAM interpolation. Alternatively, the user can provide a list of arguments to \code{mgcv::s()} the same length and order as number of unique individuals (i.e., \code{unique(paths[, ID.name])}). Each entry in the list should be a named list/vector (e.g., \code{s_args = list(list(k = 10), list(k = 12), ...)}).}

\item{simulation}{logical. Generate simulation predictions to have multiple projects for the animal paths; default is \code{FALSE}.}

\item{simulation.iter}{an integer of how many paths the crawl model will generate; default is 5.}

\item{tail.alpha}{alpha value for the tails}

\item{tail.colors}{default is \code{"gray87"}. Can be single color or vector of colors.}

\item{tail.length}{Length of the tail trailing each individual.}

\item{tail.wd}{Thickness of tail trailing behind each individual. Default is 1.}

\item{theme_map}{plot theme for \code{ggplot}, default is \code{NULL}}

\item{times}{If all paths are already synchronous, another option for passing the data is to define \code{paths} as a list of matrices, all with the same number of rows, and to specify the times separately via this argument.}

\item{uncertainty.level}{value in (0, 1) corresponding to \code{level} at which to draw uncertainty ellipses. \code{NA} (default) results in no ellipses.}

\item{uncertainty.type}{State what type of uncertainty plot 1 is default for tails more than 1 is amount of predicted trajectories for each unique individual and blurs for blur plot}

\item{whole.path}{logical. If \code{TRUE} (default = \code{FALSE}), the complete interpolated trajectories will be plotted in the background of the animation. If \code{whole.path = TRUE}, consider also setting \code{tail.length = 0}.}

\item{xlim}{Boundaries for plotting. If left undefined, the range of the data will be used.}

\item{ylim}{Boundaries for plotting. If left undefined, the range of the data will be used.}

\item{verbose}{logical; \code{TRUE} prints messages about fitting details}

\item{...}{other arguments to be passed to \code{ani.options} to animation options such as the time interval between image frames.}
}
\value{
video file, possibly a directory containing the individual images, or interpolated paths.
}
\description{
Animates telemetry data for the purposed of EDA using smoothing splines to interpolate the observed locations. The animations are particularly useful when examining multiple simultaneous trajectories. The output of the call to \code{animate_paths()} should bring up a browser window that shows the animation. Additionally, the images generated in \code{images/} (or else the value set for \code{imgdir}) may be used with ffmpeg, latex, or other presentation software that can build animations directly from a sequence of images.
}
\examples{
##
vultures$POSIX <- as.POSIXct(vultures$timestamp, tz = "UTC")
vultures_paths <- vultures[vultures$POSIX > as.POSIXct("2009-03-01", origin = "1970-01-01") &
  vultures$POSIX < as.POSIXct("2009-05-01", origin = "1970-01-01"), ]
animate_paths(
  paths = vultures_paths,
  delta.t = "week",
  coord = c("location.long", "location.lat"),
  Time.name = "POSIX",
  ID.name = "individual.local.identifier"
)
\dontrun{
background <- list(
  center = c(-90, 10),
  zoom = 3,
  maptype = "satellite"
)
library(ggmap)
library(RColorBrewer)
COVARIATE <- cos(as.numeric(vultures_paths$timestamp) /
  diff(range(as.numeric(vultures_paths$timestamp))) * 4 * pi)
animate_paths(
  paths = cbind(vultures_paths, COVARIATE),
  delta.t = "week",
  coord = c("location.long", "location.lat"),
  Time.name = "POSIX", covariate = "COVARIATE",
  covariate.colors = brewer.pal(n = 9, "RdYlGn"),
  ID.name = "individual.local.identifier",
  background = background
)

# animation using crawl interpolation
animate_paths(
  paths = vultures_paths,
  delta.t = "week",
  coord = c("location.long", "location.lat"),
  Time.name = "POSIX",
  ID.name = "individual.local.identifier",
  interpolation_type = "crawl"
)
}

# Run to remove files generated by this function
system("rm -r js; rm -r css; rm -r images; rm index.html")

}
