% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createCluster.R
\name{createCluster}
\alias{createCluster}
\title{Create a thermal cluster}
\usage{
createCluster(area, cluster_name, ..., time_series = NULL,
  prepro_data = NULL, prepro_modulation = NULL, add_prefix = TRUE,
  overwrite = FALSE, opts = antaresRead::simOptions())
}
\arguments{
\item{area}{The area where to create the cluster.}

\item{cluster_name}{cluster name.}

\item{...}{Parameters to write in the Ini file. Careful!
Some parameters must be set as \code{integers} to avoid warnings in Antares, for example, 
to set \code{unitcount}, you'll have to use \code{unitcount = 1L}.}

\item{time_series}{the "ready-made" 8760-hour time-series available for simulation purposes.}

\item{prepro_data}{Pre-process data, a \code{data.frame} or \code{matrix}, 
default is a matrix with 365 rows and 6 columns.}

\item{prepro_modulation}{Pre-process modulation, a \code{data.frame} or \code{matrix}, 
if specified, must have 8760 rows and 1 or 4 columns.}

\item{add_prefix}{If \code{TRUE}, cluster_name will be prefixed by area name.}

\item{overwrite}{Logical, overwrite the cluster or not.}

\item{opts}{List of simulation parameters returned by the function
\code{antaresRead::setSimulationPath}}
}
\value{
An updated list containing various information about the simulation.
}
\description{
Create a thermal cluster
}
\examples{
\dontrun{

library(antaresRead)
library(antaresEditObject)

# Create a cluster :
createCluster(
  area = "fr", 
  cluster_name = "my_cluster",
  group = "other", 
  unitcount = 1L, # or as.integer(1)
  `marginal-cost` = 50
)
# by default, cluster name is prefixed 
# by the area name
levels(readClusterDesc()$cluster)
# > "fr_my_cluster"

# To prevent this, use `add_prefix`
createCluster(
  area = "fr", 
  cluster_name = "my_cluster",
  add_prefix = FALSE,
  group = "other", 
  `marginal-cost` = 50
)
levels(readClusterDesc()$cluster)
# > "my_cluster"


# Pre-process data : 

#Æ this is the default data :
createCluster(
  area = "fr", 
  cluster_name = "my_cluster",
  prepro_data = matrix(
    data = c(rep(1, times = 365 * 2),
             rep(0, times = 365 * 4)), 
    ncol = 6
  )
)

# with a data.frame
createCluster(
  area = "fr", 
  cluster_name = "my_cluster",
  prepro_data = data.frame(
    v1 = rep(7, 365), # column name doesn't matter
    v2 = rep(27, 365),
    v3 = rep(0.05, 365),
    v4 = rep(0.12, 365),
    v5 = rep(0, 365),
    v6 = rep(1, 365)
  )
)


# Pre-process modulation : 
# this is the default data
createCluster(
  area = "fr", 
  cluster_name = "my_cluster",
  prepro_modulation =  = matrix(
    data = c(rep(1, times = 365 * 24 * 3),
             rep(0, times = 365 * 24 * 1)),
    ncol = 4
  )
)

# with a data.frame
createCluster(
  area = "fr", 
  cluster_name = "my_cluster",
  prepro_modulation = data.frame(
    var1 = rep(0, 8760), # column name doesn't matter
    var2 = rep(1, 8760),
    var3 = rep(0, 8760),
    var4 = rep(1, 8760)
  )
)

}
}
