% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeInputTS.R
\name{writeInputTS}
\alias{writeInputTS}
\title{Write input time series}
\usage{
writeInputTS(
  area,
  type = c("load", "hydroROR", "hydroSTOR", "wind", "solar"),
  data,
  overwrite = TRUE,
  opts = antaresRead::simOptions()
)
}
\arguments{
\item{area}{The area where to write the input time series.}

\item{type}{Serie to write: \code{"load"}, \code{"hydroROR"}, \code{"hydroSTOR"},
\code{"wind"} or \code{"solar"}.}

\item{data}{A 8760*N matrix of hourly time series, except when \code{type} is
\code{"hydroSTOR"}. In this latter case, \code{data} must either be 365*N
(Antares v7) or 12*N (v6 and earlier).}

\item{overwrite}{Logical. Overwrite the values if a file already exists.}

\item{opts}{List of simulation parameters returned by the function
\code{antaresRead::setSimulationPath}.}
}
\description{
This function writes input time series in an Antares project.
}
\examples{
\dontrun{

writeInputTS("fictive_area", type = "solar", data = matrix(rep(4, 8760*2), nrow = 8760))

}
}
