% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/editClusterST.R
\name{editClusterST}
\alias{editClusterST}
\title{Edit a short-term storage cluster}
\usage{
editClusterST(
  area,
  cluster_name,
  group = NULL,
  storage_parameters = NULL,
  PMAX_injection = NULL,
  PMAX_withdrawal = NULL,
  inflows = NULL,
  lower_rule_curve = NULL,
  upper_rule_curve = NULL,
  add_prefix = TRUE,
  opts = antaresRead::simOptions()
)
}
\arguments{
\item{area}{The area where to create the cluster.}

\item{cluster_name}{Name for the cluster, it will prefixed by area name, unless you set \code{add_prefix = FALSE}.}

\item{group}{Group of the cluster, one of : "PSP_open", "PSP_closed", "Pondage", "Battery", "Other". It corresponds to the type of stockage.}

\item{storage_parameters}{Parameters to write in the Ini file.}

\item{PMAX_injection}{modulation of charging capacity on an 8760-hour basis. The values are float between 0 and 1.}

\item{PMAX_withdrawal}{modulation of discharging capacity on an 8760-hour basis. The values are float between 0 and 1.}

\item{inflows}{imposed withdrawals from the stock for other uses, The values are integer.}

\item{lower_rule_curve}{This is the lower limit for filling the stock imposed each hour. The values are float between 0 and 1.}

\item{upper_rule_curve}{This is the upper limit for filling the stock imposed each hour. The values are float between 0 and 1.}

\item{add_prefix}{If \code{TRUE} (the default), \code{cluster_name} will be prefixed by area name.}

\item{opts}{List of simulation parameters returned by the function
\code{\link[antaresRead:setSimulationPath]{antaresRead::setSimulationPath()}}}
}
\value{
An updated list containing various information about the simulation.
}
\description{
\ifelse{html}{\figure{badge_api_ok.svg}{options: alt='Antares API OK'}}{Antares API: \strong{OK}}

Edit parameters and time series of an existing \code{st-storage} cluster (Antares studies >= v8.6.0).
}
\seealso{
\code{\link[=createClusterST]{createClusterST()}} to edit existing clusters, \code{\link[=removeClusterST]{removeClusterST()}} to remove clusters.
}
