% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_XY.R
\name{plotXY}
\alias{plotXY}
\title{Plot density between X et Y with rbokeh}
\usage{
plotXY(data, x, y, precision = 30, sizeOnCount = FALSE,
  outLine = TRUE, transform = NULL)
}
\arguments{
\item{data}{\code{data.frame} can be antaresData object}

\item{x}{\code{character}, x variable}

\item{y}{\code{character}, y variable}

\item{precision}{\code{numeric} precision for plot}

\item{sizeOnCount}{\code{boolean}, should addapt size of object based on count}

\item{outLine}{\code{boolean}, add outline on your shape}

\item{transform}{\code{funciton}, transform function apply on count (by cells), can be log}
}
\description{
This function take somes arguments from rbokeh and make plot.
}
\examples{
\dontrun{

setSimulationPath("myStudy")
myData <- readAntares()

plotXY(myData, "NODU", "LOAD", precision = 50,
         sizeOnCount = FALSE)
         
myData <- readAntares(areas = "all", links = "all")    
myData <- mergeAllAntaresData(myData)  
plotXY(myData, "OP. COST_max_b", "OP. COST_max_c", precision = 50,
         sizeOnCount = FALSE)
         
         
}
   
}
