## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = identical(tolower(Sys.getenv("NOT_CRAN")), "true"),
  out.width = "100%"
)

## ----message = FALSE, eval = TRUE---------------------------------------------
library(aopdata)
library(sf)
library(ggplot2)
library(data.table)
library(scales)

## ----message = FALSE, eval = TRUE---------------------------------------------
# download aop data
df <- aopdata::read_access(city='Curitiba',
                       mode='public_transport',
                      year=2019,
                      peak = FALSE,
                      geometry = TRUE,
                      showProgress = FALSE)

## ----message = FALSE, eval = TRUE---------------------------------------------
ggplot() +
  geom_sf(data=df, aes(fill=CMATT60), color=NA, alpha=.9) +
  scale_fill_viridis_c(option = "inferno", labels = scales::comma) +
  labs(title='Number of jobs accessible', fill="Accessibility",
       subtitle='by public transport in less than 60 min.') +
  theme_void()



## ----message = FALSE, eval = TRUE---------------------------------------------
ggplot() +
  geom_sf(data=df, aes(fill=CMAET30), color=NA, alpha=.9) +
  scale_fill_viridis_c(option = "cividis", labels=scales::comma) +
    labs(title='Number of schools accessible', fill="Accessibility",
       subtitle='by public transport in less than 30 min.', fill="N. of schools") +
  theme_void()


