% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orsf_control.R
\name{orsf_control_net}
\alias{orsf_control_net}
\title{Penalized Cox regression ORSF control}
\usage{
orsf_control_net(alpha = 1/2, df_target = NULL, ...)
}
\arguments{
\item{alpha}{(\emph{double}) The elastic net mixing parameter. A value of 1 gives the
lasso penalty, and a value of 0 gives the ridge penalty. If multiple
values of alpha are given, then a penalized model is fit using each
alpha value prior to splitting a node.}

\item{df_target}{(\emph{integer}) Preferred number of variables used in a linear combination.}

\item{...}{Further arguments passed to or from other methods (not currently used).}
}
\value{
an object of class \code{'orsf_control'}, which should be used as
an input for the \code{control} argument of \link{orsf}.
}
\description{
Use regularized Cox proportional hazard models to identify linear
combinations of input variables while fitting an \link{orsf} model.
}
\details{
\code{df_target} has to be less than \code{mtry}, which is a separate argument in
\link{orsf} that indicates the number of variables chosen at random prior to
finding a linear combination of those variables.
}
\examples{

# orsf_control_net() is considerably slower than orsf_control_cph(),
# The example uses n_tree = 25 so that my examples run faster,
# but you should use at least 500 trees in applied settings.

orsf(data = pbc_orsf,
     formula = Surv(time, status) ~ . - id,
     n_tree = 25,
     control = orsf_control_net())
}
\references{
Simon N, Friedman J, Hastie T, Tibshirani R. Regularization paths for Cox's proportional hazards model via coordinate descent. \emph{Journal of statistical software} 2011 Mar; 39(5):1. DOI: 10.18637/jss.v039.i05
}
\seealso{
linear combination control functions
\code{\link{orsf_control_cph}()},
\code{\link{orsf_control_custom}()},
\code{\link{orsf_control_fast}()}
}
\concept{orsf_control}
