% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{add_event}
\alias{add_event}
\title{Add an event to a chart}
\usage{
add_event(ax, when, color = "#E41A1C", dash = 4, label = NULL, ...)
}
\arguments{
\item{ax}{An \code{apexcharts} \code{htmlwidget} object.}

\item{when}{Vector of position to place the event.}

\item{color}{Color of the line.}

\item{dash}{Creates dashes in borders of SVG path.
A higher number creates more space between dashes in the border.
Use \code{0} for plain line.}

\item{label}{Add a label to the shade, use a \code{character}
or see \code{\link{label}} for more controls.}

\item{...}{Additional arguments, see
\url{https://apexcharts.com/docs/options/annotations/} for possible options.}
}
\value{
An \code{apexcharts} \code{htmlwidget} object.
}
\description{
Add a vertical line to mark a special event on a chart.
}
\examples{
library(apexcharter)
data("consumption")

# specify from and to date
apex(consumption, aes(date, value, group = type), "spline") \%>\% 
  add_event(when = "2020-01-11")

# several events
apex(consumption, aes(date, value, group = type), "spline") \%>\% 
  add_event(when = c("2020-01-11", "2020-01-29"))

# Add labels on events
apex(consumption, aes(date, value, group = type), "spline") \%>\% 
  add_event(
    when = c("2020-01-11", "2020-01-29"),
    label = label(text = c("Am", "Ar"))
  )

# can be combined with shade
apex(consumption, aes(date, value, group = type), "spline") \%>\% 
  add_shade(from = "2020-01-06", to = "2020-01-20")\%>\% 
  add_event(when = c("2020-01-11", "2020-01-29"))
}
