% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixed-charts.R
\name{add-line}
\alias{add-line}
\alias{add_line}
\alias{add_smooth_line}
\title{Add a line to a chart}
\usage{
add_line(
  ax,
  mapping,
  data = NULL,
  type = c("line", "spline"),
  serie_name = NULL
)

add_smooth_line(
  ax,
  formula = y ~ x,
  model = c("lm", "loess"),
  n = 100,
  ...,
  type = c("line", "spline"),
  serie_name = NULL
)
}
\arguments{
\item{ax}{An \code{\link{apex}} \code{htmlwidget} object.}

\item{mapping}{Default list of aesthetic mappings to use for chart.}

\item{data}{A \code{data.frame} to use to add a line, if \code{NULL} (default),
the \code{data.frame} provided in \code{apex()} will be used.}

\item{type}{Type of line.}

\item{serie_name}{Name for the serie displayed in tooltip and legend.}

\item{formula}{Formula passed to the \code{method}, default to \code{y ~ x} from main aesthetics.}

\item{model}{Model to use between \code{\link{lm}} or \code{\link{loess}}.}

\item{n}{Number of points used for predictions.}

\item{...}{Arguments passed to \code{model}.}
}
\value{
A \code{apexcharts} \code{htmlwidget} object.
}
\description{
Add a line to an existing chart (bar, scatter and line types supported).
On scatter charts you can also add a smooth line.
}
\examples{
library(apexcharter)


# Bar ----

data("climate_paris")

# Add a line on a column's chart
apex(climate_paris, aes(month, precipitation), type = "column") \%>\% 
  add_line(aes(month, temperature))

# Add secondary axis
apex(climate_paris, aes(month, precipitation), type = "column") \%>\% 
  add_line(aes(month, temperature)) \%>\%
  ax_yaxis(
    title = list(text = "Precipitation (in mm)")
  ) \%>\% 
  ax_yaxis2(
    opposite = TRUE,
    decimalsInFloat = 0,
    title = list(text = "Temperature (in degree celsius)")
  ) \%>\% 
  ax_dataLabels(
    enabled = TRUE, enabledOnSeries = list(1)
  )



# Scatter ----

# add smooth line on scatter plot
apex(cars, aes(speed, dist), type = "scatter") \%>\% 
  add_line(aes(x, y), data = lowess(cars), serie_name = "lowess")


# or directly
apex(cars, aes(speed, dist), type = "scatter") \%>\% 
  add_smooth_line()

apex(cars, aes(speed, dist), type = "scatter") \%>\% 
  add_smooth_line(model = "loess", span = 1)

apex(cars, aes(speed, dist), type = "scatter") \%>\% 
  add_smooth_line(model = "loess", degree = 1)


apex(cars, aes(speed, dist), type = "scatter") \%>\% 
  add_smooth_line(formula = y ~ poly(x, 2))

apex(cars, aes(speed, dist), type = "scatter") \%>\% 
  add_smooth_line(model = "lm", serie_name = "lm") \%>\% 
  add_smooth_line(model = "loess", serie_name = "loess")





}
