# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

new_aphylo_pruner. <- function(edgelist, A, types, nannotated) {
    .Call(`_aphylo_new_aphylo_pruner`, edgelist, A, types, nannotated)
}

sizeof_pruner <- function(ptr) {
    .Call(`_aphylo_sizeof_pruner`, ptr)
}

.LogLike_pruner <- function(tree_ptr, mu_d, mu_s, psi, eta, Pi, verb = TRUE, check_dims = FALSE) {
    .Call(`_aphylo_LogLike_pruner`, tree_ptr, mu_d, mu_s, psi, eta, Pi, verb, check_dims)
}

Tree_get_offspring <- function(tree_ptr) {
    .Call(`_aphylo_Tree_get_offspring`, tree_ptr)
}

Tree_get_parents <- function(tree_ptr) {
    .Call(`_aphylo_Tree_get_parents`, tree_ptr)
}

.Nnode_aphylo_pruner <- function(tree_ptr, internal_only = TRUE) {
    .Call(`_aphylo_Tree_Nnode`, tree_ptr, internal_only)
}

#' @rdname new_aphylo_pruner
#' @param ptr An object of class `aphylo_pruner`.
#' @return `dist2root`: An integer vector with the number of steps from each
#' node (internal or not) to the root node.
#' @export
dist2root <- function(ptr) {
    .Call(`_aphylo_Tree_get_dist_tip2root`, ptr)
}

#' @rdname new_aphylo_pruner
#' @return `get_postorder`: An integer vector with the postorder sequence
#' for pruning the tree (indexed from 0).
#' @export
get_postorder <- function(ptr) {
    .Call(`_aphylo_Tree_get_postorder`, ptr)
}

#' @export
Ntip.aphylo_pruner <- function(phy) {
    .Call(`_aphylo_Tree_Ntip`, phy)
}

#' @export
Nannotated.aphylo_pruner <- function(phy) {
    .Call(`_aphylo_Tree_Nannotated`, phy)
}

#' @export
Nann.aphylo_pruner <- function(phy) {
    .Call(`_aphylo_Tree_Nann`, phy)
}

Tree_set_ann <- function(phy, i, j, val) {
    .Call(`_aphylo_Tree_set_ann`, phy, i, j, val)
}

Tree_get_ann <- function(phy) {
    .Call(`_aphylo_Tree_get_ann`, phy)
}

#' Area Under the Curve and Receiving Operating Curve
#' 
#' The AUC values are computed by approximation using the area of the polygons formed
#' under the ROC curve.
#' @param pred A numeric vector with the predictions of the model. Values must
#' range between 0 and 1.
#' @param labels An integer vector with the labels (truth). Values should be either
#' 0 or 1.
#' @param nc Integer. Number of cutoffs to use for computing the rates and AUC.
#' @param nine_na Logical. When `TRUE`, 9 is treated as `NA`.
#' @return A list:
#' - `tpr` A vector of length `nc` with the True Positive Rates.
#' - `tnr` A vector of length `nc` with the True Negative Rates.
#' - `fpr` A vector of length `nc` with the False Positive Rates.
#' - `fnr` A vector of length `nc` with the False Negative Rates.
#' - `auc` A numeric value. Area Under the Curve.
#' - `cutoffs` A vector of length `nc` with the cutoffs used.
#' @export
#' @examples
#' set.seed(8381)
#' x   <- rdrop_annotations(raphylo(50), .3)
#' ans <- aphylo_mcmc(x ~ mu_d + mu_s + Pi)
#' ans_auc <- auc(predict(ans, loo = TRUE), x[,1,drop=TRUE])
#' print(ans_auc)
#' plot(ans_auc)
auc <- function(pred, labels, nc = 200L, nine_na = TRUE) {
    .Call(`_aphylo_auc`, pred, labels, nc, nine_na)
}

#' Matrix of states
#' 
#' @param P Integer scalar. Number of functions.
#' @return A matrix of size 2^P by P with all the possible
#' (0,1) combinations of functions.
#' @examples
#' states(3)
#' @export
states <- function(P) {
    .Call(`_aphylo_states`, P)
}

prob_mat <- function(pr) {
    .Call(`_aphylo_prob_mat`, pr)
}

root_node_prob <- function(Pi, S) {
    .Call(`_aphylo_root_node_prob`, Pi, S)
}

#' Reduces the peeling sequence so that only nodes that have something to contribute
#' are included in the sequence.
#' @noRd
reduce_pseq <- function(pseq, A, offspring) {
    .Call(`_aphylo_reduce_pseq`, pseq, A, offspring)
}

.posterior_prob <- function(Pr_postorder, types, mu_d, mu_s, Pi, pseq, offspring) {
    .Call(`_aphylo_posterior_prob`, Pr_postorder, types, mu_d, mu_s, Pi, pseq, offspring)
}

.sim_fun_on_tree <- function(offspring, types, pseq, psi, mu_d, mu_s, eta, Pi, P = 1L) {
    .Call(`_aphylo_sim_fun_on_tree`, offspring, types, pseq, psi, mu_d, mu_s, eta, Pi, P)
}

.sim_tree <- function(n, f, branches) {
    .Call(`_aphylo_sim_tree`, n, f, branches)
}

