% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guessColumnNames.R
\name{guessHzTexClName}
\alias{guessHzTexClName}
\title{Guess Horizon Texture Class Column Name}
\usage{
guessHzTexClName(x)
}
\arguments{
\item{x}{A SoilProfileCollection}
}
\value{
Character containing horizon texture class column name.
}
\description{
This function is used to provide a texture class attribute column name to functions. It will use regular expressions to match "texcl" which is typically the texture of the fine earth fraction, without modifiers or in-lieu textures. Alternately, it will match "texture" for cases where "texcl" is absent (e.g. in NASIS Component Horizon).
}
\examples{

a <- data.frame(id = 1, top = c(0,10), bottom=c(10,40), texture=c("A","Bw"))
depths(a) <- id ~ top + bottom

# store guess in metadata
hzdesgnname(a) <- guessHzTexClName(a)

# inspect result
hzdesgnname(a)

}
\seealso{
\code{\link{guessHzDesgnName}}, \code{\link{guessHzAttrName}}
}
\author{
Andrew G. Brown
}
