% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/archive.R
\name{archive}
\alias{archive}
\title{Construct a new archive}
\usage{
archive(file, options = character())
}
\arguments{
\item{file}{File path to the archive.}

\item{options}{\code{character()} default: \code{character(0)} Options to pass to the filter or format.
The list of available options are documented in
options can have one of the following forms:
\itemize{
\item \code{option=value}
The option/value pair will be provided to every module.
Modules that do not accept an option with this name will
ignore it.
\item \code{option}
The option will be provided to every module with a value
of "1".
\item \code{!option}
The option will be provided to every module with a NULL
value.
\item \code{module:option=value}, \code{module:option}, \code{module:!option}
As above, but the corresponding option and value will be
provided only to modules whose name matches module.
See \href{https://www.freebsd.org/cgi/man.cgi?query=archive_read_set_options&sektion=3&format=html}{read options} for available read options
See \href{https://www.freebsd.org/cgi/man.cgi?query=archive_write_set_options&sektion=3&format=html}{write options} for available write options
}}
}
\value{
@return A \link[tibble:tibble-package]{tibble} with details about files in the archive.
}
\description{
This function retrieves metadata about files in an archive, it can be passed
to \code{\link[=archive_read]{archive_read()}} or \link{archive_write} to create a connection to read or
write a specific file from the archive.
}
\examples{
a <- archive(system.file(package = "archive", "extdata", "data.zip"))
a
}
\seealso{
\code{\link[=archive_read]{archive_read()}}, \code{\link[=archive_write]{archive_write()}} to read and write archive files
using R connections, \code{\link[=archive_extract]{archive_extract()}}, \code{\link[=archive_write_files]{archive_write_files()}},
\code{\link[=archive_write_dir]{archive_write_dir()}} to add or extract files from an archive.
}
