% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asession.R
\name{asession}
\alias{asession}
\title{Show Artifact's Session Info}
\usage{
asession(md5hash = NULL)
}
\arguments{
\item{md5hash}{One of the following (see \link{aread}):

A character vector which elements  are consisting of at least three components separated with '/': Remote user name, Remote repository and name of the artifact (MD5 hash) or it's abbreviation.

MD5 hashes of artifacts in current local default directory or its abbreviations.}
}
\value{
An object of the class \code{session_info}.
}
\description{
\code{asession} extracts artifact's session info. This allows to check in what conditions 
the artifact was created.
}
\note{
Bug reports and feature requests can be sent to \href{https://github.com/pbiecek/archivist/issues}{https://github.com/pbiecek/archivist/issues}
}
\examples{
\dontrun{
setLocalRepo(system.file("graphGallery", package = "archivist"))
asession("2a6e492cb6982f230e48cf46023e2e4f")

# no session info
asession("pbiecek/graphGallery/2a6e492cb6982f230e48cf46023e2e4f")
# nice session info
asession("pbiecek/graphGallery/f05f0ed0662fe01850ec1b928830ef32")
}
}
\author{
Przemyslaw Biecek, \email{przemyslaw.biecek@gmail.com}
}
\seealso{
Other archivist: \code{\link{Repository}},
  \code{\link{Tags}}, \code{\link{\%a\%}},
  \code{\link{addHooksToPrint}}, \code{\link{addTagsRepo}},
  \code{\link{aformat}}, \code{\link{ahistory}},
  \code{\link{alink}}, \code{\link{aoptions}},
  \code{\link{archivist-package}}, \code{\link{aread}},
  \code{\link{asearch}}, \code{\link{cache}},
  \code{\link{copyLocalRepo}},
  \code{\link{createLocalRepo}},
  \code{\link{createMDGallery}},
  \code{\link{deleteLocalRepo}},
  \code{\link{getRemoteHook}}, \code{\link{getTagsLocal}},
  \code{\link{loadFromLocalRepo}}, \code{\link{md5hash}},
  \code{\link{restoreLibs}}, \code{\link{rmFromLocalRepo}},
  \code{\link{saveToLocalRepo}},
  \code{\link{searchInLocalRepo}},
  \code{\link{setLocalRepo}},
  \code{\link{shinySearchInLocalRepo}},
  \code{\link{showLocalRepo}},
  \code{\link{splitTagsLocal}},
  \code{\link{summaryLocalRepo}},
  \code{\link{zipLocalRepo}}
}

