% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve_layers.R
\name{get_spatial_layer}
\alias{get_spatial_layer}
\title{Retrieve a feature service layer from an ArcGIS REST API}
\usage{
get_spatial_layer(
  url,
  out_fields = c("*"),
  where = "1=1",
  token = "",
  sf_type = NULL,
  head = FALSE,
  ...
)
}
\arguments{
\item{url}{A character string of the url for the layer to pull}

\item{out_fields}{A character string of the fields to pull for each layer}

\item{where}{A character string of the where condition. Default is 1=1}

\item{token}{A character string of the token (if needed)}

\item{sf_type}{A character string specifying the layer geometry to convert to
sf ("esriGeometryPolygon", "esriGeometryPoint", "esriGeometryPolyline"),
if NULL (default) the server will take its best guess}

\item{head}{Logical or numeric. Limits the number of records returned from a
query. If TRUE, only the first 10 records will be returned. If numeric, then
the number of records specified in \code{head} will be returned}

\item{...}{Additional arguements to pass to the ArcGIS REST POST request}
}
\value{
An object of class "sf" of the appropriate layer
}
\description{
This function retrieves spatial layers present in Feature Service layers of
an ArcGIS REST services API and returns them as an \code{sf} object
}
\details{
This is one of the core functions of this package. It retrieves spatial
layers from feature services of an ArcGIS REST API designated by the URL.
Additional querying features can be passed such as a SQL WHERE statement
(\code{where} argument) or spatial queries as well as any other types of
queries that the ArcGIS REST API accepts (using \code{...}). However, for
easier spatial querying see \code{\link{get_layers_by_spatial}}.

All of the querying parameters are sent via a POST request to the URL, so
if there are issues with passing additional parameters via \code{...}
first determine how they fit into the POST request and make adjustments as
needed. This syntax can be tricky if you're not used to it.
}
\examples{
\dontrun{
# lava flows on Reykjanes (pr. 'rake-yah-ness') peninsula in Iceland
lava_flows <- get_spatial_layer(reykjanes_lava_flow_url)
plot_layer(lava_flows, outline_poly = reykjanes_poly)
plot_layer(lava_flows, outline_poly = iceland_poly)
}
}
